/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.serial;

import com.intelligt.modbus.jlibmodbus.serial.SerialParameters;
import com.intelligt.modbus.jlibmodbus.serial.SerialPort;
import com.intelligt.modbus.jlibmodbus.serial.SerialPortException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SerialPortJSerialComm
extends SerialPort {
    private com.fazecast.jSerialComm.SerialPort port;
    private InputStream in;
    private OutputStream out;
    final byte[] b = new byte[1];

    public SerialPortJSerialComm(SerialParameters sp) {
        super(sp);
    }

    @Override
    public void write(int b) throws IOException {
        if (!this.isOpened()) {
            throw new IOException("Port not opened");
        }
        try {
            this.out.write((byte)b);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        if (!this.isOpened()) {
            throw new IOException("Port not opened");
        }
        try {
            this.out.write(bytes);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void open() throws SerialPortException {
        SerialParameters sp = this.getSerialParameters();
        this.port = com.fazecast.jSerialComm.SerialPort.getCommPort((String)sp.getDevice());
        this.port.openPort();
        this.port.setComPortParameters(sp.getBaudRate(), sp.getDataBits(), sp.getStopBits(), sp.getParity().getValue());
        this.port.setFlowControl(0);
        this.in = this.port.getInputStream();
        this.out = this.port.getOutputStream();
        this.port.setComPortTimeouts(256, this.getReadTimeout(), 0);
    }

    @Override
    public void setReadTimeout(int readTimeout) {
        super.setReadTimeout(readTimeout);
        if (this.isOpened()) {
            this.port.setComPortTimeouts(0, this.getReadTimeout(), this.getReadTimeout());
        }
    }

    @Override
    public int read() throws IOException {
        int c;
        if (!this.isOpened()) {
            throw new IOException("Port not opened");
        }
        try {
            c = this.in.read(this.b, 0, this.b.length);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        if (c > 0) {
            return this.b[0];
        }
        throw new IOException("Read timeout");
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int c;
        if (!this.isOpened()) {
            throw new IOException("Port not opened");
        }
        try {
            c = this.in.read(b, off, len);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        if (c > -1) {
            return c;
        }
        throw new IOException("Read timeout");
    }

    @Override
    public void close() {
        try {
            if (this.isOpened()) {
                this.in.close();
                this.out.close();
                this.port.closePort();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isOpened() {
        return this.port.isOpen();
    }
}

