/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.slave;

import com.intelligt.modbus.jlibmodbus.Modbus;
import com.intelligt.modbus.jlibmodbus.data.CommStatus;
import com.intelligt.modbus.jlibmodbus.data.DataHolder;
import com.intelligt.modbus.jlibmodbus.data.comm.ModbusCommEventSend;
import com.intelligt.modbus.jlibmodbus.exception.ModbusChecksumException;
import com.intelligt.modbus.jlibmodbus.exception.ModbusIOException;
import com.intelligt.modbus.jlibmodbus.msg.base.ModbusRequest;
import com.intelligt.modbus.jlibmodbus.msg.base.ModbusResponse;
import com.intelligt.modbus.jlibmodbus.msg.request.GetCommEventCounterRequest;
import com.intelligt.modbus.jlibmodbus.msg.request.GetCommEventLogRequest;
import com.intelligt.modbus.jlibmodbus.net.ModbusConnection;
import com.intelligt.modbus.jlibmodbus.net.transport.ModbusTransport;
import com.intelligt.modbus.jlibmodbus.slave.ModbusSlave;
import com.intelligt.modbus.jlibmodbus.slave.RequestHandler;

class RequestHandlerSerial
extends RequestHandler {
    RequestHandlerSerial(ModbusSlave slave, ModbusConnection conn) {
        super(slave, conn);
    }

    @Override
    public void closeConnection() {
        this.setListening(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.getConnection().open();
            this.getSlave().connectionOpened(this.getConnection());
            this.setListening(true);
            do {
                DataHolder dataHolder = this.getSlave().getDataHolder();
                CommStatus commStatus = dataHolder.getCommStatus();
                ModbusTransport transport = this.getConnection().getTransport();
                try {
                    ModbusRequest request = (ModbusRequest)transport.readRequest();
                    commStatus.incBusMessageCounter();
                    if (!(request instanceof GetCommEventCounterRequest) && !(request instanceof GetCommEventLogRequest)) {
                        commStatus.enter();
                    }
                    if (request.getServerAddress() == this.getSlave().getServerAddress()) {
                        try {
                            ModbusResponse response = request.process(dataHolder);
                            commStatus.incSlaveMessageCounter();
                            if (response.isException()) {
                                commStatus.addEvent(ModbusCommEventSend.createExceptionSentRead());
                                commStatus.incExErrorCounter();
                            } else if (!(request instanceof GetCommEventCounterRequest) && !(request instanceof GetCommEventLogRequest)) {
                                commStatus.incEventCounter();
                            }
                            if (!commStatus.isListenOnlyMode()) {
                                transport.send(response);
                            }
                            if (!commStatus.isRestartCommunicationsOption()) continue;
                            commStatus.restartCommunicationsOption();
                            this.getSlave().shutdown();
                            this.getSlave().listen();
                            continue;
                        }
                        catch (RuntimeException re) {
                            throw re;
                        }
                        catch (Exception e) {
                            commStatus.incNoResponseCounter();
                            throw e;
                        }
                    }
                    if (request.getServerAddress() != 0 || !this.getSlave().isBroadcastEnabled()) continue;
                    request.process(dataHolder);
                }
                catch (ModbusChecksumException e) {
                    commStatus.incCommErrorCounter();
                }
                catch (Exception e) {
                    Modbus.log().warning(e.getLocalizedMessage());
                }
                finally {
                    commStatus.leave();
                }
            } while (this.isListening());
            if (this.getConnection().isOpened()) {
                this.getConnection().close();
                this.getSlave().connectionClosed(this.getConnection());
            }
        }
        catch (ModbusIOException e) {
            Modbus.log().warning(e.getMessage());
        }
    }
}

