/*
 * Decompiled with CFR 0.152.
 */
package com.jdcloud.sdk.service.sms.client;

import com.jdcloud.sdk.JdcloudSdkException;
import com.jdcloud.sdk.auth.CredentialsProvider;
import com.jdcloud.sdk.client.Environment;
import com.jdcloud.sdk.client.Jdcloud;
import com.jdcloud.sdk.client.JdcloudClient;
import com.jdcloud.sdk.client.JdcloudValidateException;
import com.jdcloud.sdk.http.HttpRequestConfig;
import com.jdcloud.sdk.service.JdcloudRequest;
import com.jdcloud.sdk.service.sms.client.BatchSendExecutor;
import com.jdcloud.sdk.service.sms.client.ReplyExecutor;
import com.jdcloud.sdk.service.sms.client.StatusReportExecutor;
import com.jdcloud.sdk.service.sms.model.BatchSendRequest;
import com.jdcloud.sdk.service.sms.model.BatchSendResponse;
import com.jdcloud.sdk.service.sms.model.ReplyRequest;
import com.jdcloud.sdk.service.sms.model.ReplyResponse;
import com.jdcloud.sdk.service.sms.model.StatusReportRequest;
import com.jdcloud.sdk.service.sms.model.StatusReportResponse;

public class SmsClient
extends JdcloudClient {
    public static final String ApiVersion = "v1";
    private static final String UserAgentPrefix = "JdcloudSdkJava";
    public static final String ClientVersion = "1.2.1";
    public static final String DefaultEndpoint = "sms.jdcloud-api.com";
    public static final String ServiceName = "sms";
    public static final String UserAgent = "JdcloudSdkJava/1.2.1 sms/v1";
    CredentialsProvider credentialsProvider;
    HttpRequestConfig httpRequestConfig;
    Environment environment = new Environment.Builder().endpoint("sms.jdcloud-api.com").build();

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public HttpRequestConfig getHttpRequestConfig() {
        return this.httpRequestConfig;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public String getUserAgent() {
        return UserAgent;
    }

    public String getServiceName() {
        return ServiceName;
    }

    public String getVersion() {
        return ApiVersion;
    }

    private SmsClient() {
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    public BatchSendResponse batchSend(BatchSendRequest request) throws JdcloudSdkException {
        return (BatchSendResponse)new BatchSendExecutor().client(this).execute((JdcloudRequest)request);
    }

    public StatusReportResponse statusReport(StatusReportRequest request) throws JdcloudSdkException {
        return (StatusReportResponse)new StatusReportExecutor().client(this).execute((JdcloudRequest)request);
    }

    public ReplyResponse reply(ReplyRequest request) throws JdcloudSdkException {
        return (ReplyResponse)new ReplyExecutor().client(this).execute((JdcloudRequest)request);
    }

    private static class DefaultBuilder
    implements Builder {
        private SmsClient smsClient = new SmsClient();

        @Override
        public DefaultBuilder credentialsProvider(CredentialsProvider provider) {
            this.smsClient.credentialsProvider = provider;
            return this;
        }

        @Override
        public DefaultBuilder httpRequestConfig(HttpRequestConfig config) {
            this.smsClient.httpRequestConfig = config;
            return this;
        }

        @Override
        public SmsClient build() throws JdcloudSdkException {
            if (this.smsClient.credentialsProvider == null) {
                this.smsClient.credentialsProvider = Jdcloud.defaultInstance().getCredentialsProvider();
                if (this.smsClient.credentialsProvider == null) {
                    throw new JdcloudValidateException("SmsClient build error: jdcloud credentials provider not set");
                }
            }
            if (this.smsClient.httpRequestConfig == null) {
                this.smsClient.httpRequestConfig = Jdcloud.defaultInstance().getHttpRequestConfig();
                if (this.smsClient.httpRequestConfig == null) {
                    throw new JdcloudValidateException("SmsClient build error: http request config not set");
                }
            }
            return this.smsClient;
        }

        @Override
        public Builder environment(Environment environment) {
            this.smsClient.environment = environment;
            return this;
        }
    }

    public static interface Builder {
        public Builder credentialsProvider(CredentialsProvider var1);

        public Builder environment(Environment var1);

        public Builder httpRequestConfig(HttpRequestConfig var1);

        public SmsClient build() throws JdcloudSdkException;
    }
}

