/*
 * Decompiled with CFR 0.152.
 */
package com.wangyin.aks.pdf;

import com.itextpdf.text.Image;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfSignatureAppearance;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.security.BouncyCastleDigest;
import com.itextpdf.text.pdf.security.ExternalDigest;
import com.itextpdf.text.pdf.security.ExternalSignature;
import com.itextpdf.text.pdf.security.MakeSignature;
import com.itextpdf.text.pdf.security.OcspClient;
import com.itextpdf.text.pdf.security.OcspClientBouncyCastle;
import com.itextpdf.text.pdf.security.PrivateKeySignature;
import com.itextpdf.text.pdf.security.TSAClient;
import com.wangyin.aks.pdf.PDFSignerService;
import com.wangyin.aks.pdf.util.ImageTransparency;
import com.wangyin.aks.pdf.util.PDFUtil;
import com.wangyin.aks.pdf.util.PKCS12Keystore;
import com.wangyin.aks.pdf.util.TSAClientImpl;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.List;

public class PDFSignerServiceImpl
implements PDFSignerService {
    @Override
    public byte[] signPdf(byte[] pfx, String passwd, byte[] srcPdf, byte[] png, String keyWord, boolean isAll, int page) throws Exception {
        List<Float[]> signLocateList = PDFUtil.getSignLocate(srcPdf, keyWord, isAll, page);
        if (signLocateList == null || signLocateList.isEmpty()) {
            throw new RuntimeException(keyWord + " not found.");
        }
        byte[] transparencyImage = ImageTransparency.transparencyImage(png);
        Image signPng = Image.getInstance((byte[])transparencyImage);
        PKCS12Keystore pkcs12Keystore = PKCS12Keystore.getInstance(pfx, passwd);
        byte[] signPdf = srcPdf;
        for (Float[] location : signLocateList) {
            signPdf = PDFSignerServiceImpl.signPdf(signPdf, signPng, location, pkcs12Keystore);
        }
        return signPdf;
    }

    public static byte[] signPdf(byte[] pdf, Image png, Float[] location, PKCS12Keystore pkcs12Keystore) {
        byte[] signPdf = null;
        try {
            PdfReader reader = new PdfReader(pdf);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PdfStamper stamper = PdfStamper.createSignature((PdfReader)reader, (OutputStream)out, (char)'\u0000', null, (boolean)true);
            PdfSignatureAppearance signApp = stamper.getSignatureAppearance();
            signApp.setSignatureGraphic(png);
            signApp.setRenderingMode(PdfSignatureAppearance.RenderingMode.GRAPHIC);
            float pngWith = png.getWidth() / 1.46f;
            float pngHight = png.getHeight() / 1.46f;
            float llx = location[0].floatValue() - (pngWith - location[2].floatValue()) * 0.5f;
            float lly = location[1].floatValue() - (pngHight - location[3].floatValue()) * 0.5f;
            float urx = location[0].floatValue() + (pngWith + location[2].floatValue()) * 0.5f;
            float ury = location[1].floatValue() + (pngHight + location[3].floatValue()) * 0.5f;
            Rectangle rect = new Rectangle(llx, lly, urx, ury);
            signApp.setVisibleSignature(rect, location[4].intValue(), null);
            BouncyCastleDigest externalDigest = new BouncyCastleDigest();
            PrivateKeySignature externalSignature = new PrivateKeySignature(pkcs12Keystore.getPrivateKey(), "SHA1", pkcs12Keystore.getProvider().getName());
            Certificate[] chain = pkcs12Keystore.getChain();
            ArrayList crlList = new ArrayList();
            OcspClientBouncyCastle ocspClient = new OcspClientBouncyCastle(null);
            TSAClient tsaClient = PDFSignerServiceImpl.getTSAClient();
            int estimatedSize = 0;
            MakeSignature.CryptoStandard sigtype = MakeSignature.CryptoStandard.CMS;
            MakeSignature.signDetached((PdfSignatureAppearance)signApp, (ExternalDigest)externalDigest, (ExternalSignature)externalSignature, (Certificate[])chain, crlList, (OcspClient)ocspClient, (TSAClient)tsaClient, (int)estimatedSize, (MakeSignature.CryptoStandard)sigtype);
            signPdf = out.toByteArray();
            if (reader != null) {
                reader.close();
            }
            if (out != null) {
                out.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return signPdf;
    }

    private static TSAClient getTSAClient() {
        return new TSAClientImpl("http://172.24.5.156:8001/j/tsa", "200202010200000026", "7JEGJJ4G37JV3ECNWCYD");
    }
}

