/*
 * Decompiled with CFR 0.152.
 */
package com.wangyin.aks.pdf.util;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public final class ImageTransparency {
    public static byte[] transparencyImage(byte[] pngImage) throws IOException {
        ByteArrayInputStream pngIn = new ByteArrayInputStream(pngImage);
        BufferedImage bufferedImage = ImageIO.read(pngIn);
        int color = bufferedImage.getRGB(0, 0);
        Image imageWithTransparency = ImageTransparency.makeColorTransparent(bufferedImage, new Color(color));
        BufferedImage transparentImage = ImageTransparency.imageToBufferedImage(imageWithTransparency);
        return ImageTransparency.transBufferedImage2Byte(transparentImage);
    }

    private static byte[] transBufferedImage2Byte(BufferedImage bufferedImage) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "png", baos);
        return baos.toByteArray();
    }

    private static BufferedImage imageToBufferedImage(Image image) {
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D g2 = bufferedImage.createGraphics();
        g2.drawImage(image, 0, 0, null);
        g2.dispose();
        return bufferedImage;
    }

    public static Image makeColorTransparent(BufferedImage im, final Color color) {
        RGBImageFilter filter = new RGBImageFilter(){
            public int markerRGB;
            {
                this.markerRGB = color.getRGB() | 0xFFFFFFFF;
            }

            @Override
            public final int filterRGB(int x, int y, int rgb) {
                if ((rgb | 0xFF000000) == this.markerRGB) {
                    return 0xFFFFFF & rgb;
                }
                return rgb;
            }
        };
        FilteredImageSource ip = new FilteredImageSource(im.getSource(), filter);
        return Toolkit.getDefaultToolkit().createImage(ip);
    }
}

