/*
 * Decompiled with CFR 0.152.
 */
package com.wangyin.aks.pdf.util;

import com.itextpdf.awt.geom.Rectangle2D;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.parser.ImageRenderInfo;
import com.itextpdf.text.pdf.parser.PdfReaderContentParser;
import com.itextpdf.text.pdf.parser.RenderListener;
import com.itextpdf.text.pdf.parser.TextRenderInfo;
import java.util.ArrayList;
import java.util.List;

public class PDFUtil {
    private int cursorPage;

    public static List<Float[]> getSignLocate(byte[] pdf, String keyWord, boolean isAll, int page) {
        PDFUtil pdfUtil = new PDFUtil();
        return pdfUtil.searchLocation(pdf, keyWord, isAll, page);
    }

    public List<Float[]> searchLocation(byte[] pdf, final String keyWord, boolean isAll, int page) {
        final ArrayList<Float[]> signLocateList = new ArrayList<Float[]>();
        try {
            PdfReader pdfReader = new PdfReader(pdf);
            int pageNum = pdfReader.getNumberOfPages();
            if (page <= 0 || page > pageNum) {
                return signLocateList;
            }
            PdfReaderContentParser pdfReaderContentParser = new PdfReaderContentParser(pdfReader);
            int startPage = page;
            int endPage = isAll ? pageNum : page;
            this.cursorPage = startPage;
            while (this.cursorPage <= endPage) {
                pdfReaderContentParser.processContent(this.cursorPage, new RenderListener(){

                    public void renderText(TextRenderInfo renderInfo) {
                        String text = renderInfo.getText();
                        if (null != text && text.contains(keyWord)) {
                            Rectangle2D.Float boundingRectange = renderInfo.getBaseline().getBoundingRectange();
                            Float[] signLocateArrs = new Float[]{Float.valueOf(boundingRectange.x), Float.valueOf(boundingRectange.y), Float.valueOf(boundingRectange.width), Float.valueOf(boundingRectange.height), Float.valueOf(PDFUtil.this.cursorPage)};
                            signLocateList.add(signLocateArrs);
                        }
                    }

                    public void renderImage(ImageRenderInfo renderInfo) {
                    }

                    public void endTextBlock() {
                    }

                    public void beginTextBlock() {
                    }
                });
                ++this.cursorPage;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return signLocateList;
    }
}

