/*
 * Decompiled with CFR 0.152.
 */
package com.wangyin.aks.pdf.util;

import com.wangyin.aks.security.api.util.BCECUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class PKCS12Keystore {
    private static Provider provider;
    private KeyStore keystore;
    private String alias;
    private PrivateKey privateKey;
    private Certificate[] chain;
    private X509Certificate cert;
    private long expiredDate;

    private PKCS12Keystore(byte[] pfxBytes, String pfxPwd) {
        try {
            if (provider == null) {
                provider = new BouncyCastleProvider();
                Security.addProvider(provider);
            }
            this.keystore = KeyStore.getInstance("pkcs12", provider);
            ByteArrayInputStream pfxIn = new ByteArrayInputStream(pfxBytes);
            this.keystore.load(pfxIn, pfxPwd.toCharArray());
            this.alias = this.keystore.aliases().nextElement();
            this.privateKey = (PrivateKey)this.keystore.getKey(this.alias, pfxPwd.toCharArray());
            this.chain = this.keystore.getCertificateChain(this.alias);
            this.cert = (X509Certificate)this.keystore.getCertificate(this.alias);
            this.expiredDate = this.cert.getNotAfter().getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static PKCS12Keystore getInstance(byte[] pfxBytes, String pfxPwd) {
        return new PKCS12Keystore(pfxBytes, pfxPwd);
    }

    public Certificate[] getChain() {
        return this.chain;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public Provider getProvider() {
        return this.keystore.getProvider();
    }

    public long getExpireDate() {
        return this.expiredDate;
    }

    public boolean isExpired() {
        int compare = new Date().compareTo(new Date(this.expiredDate));
        return compare > 0;
    }

    public X509Certificate getCert() {
        return this.cert;
    }

    public byte[] getPrivateEncode() throws IOException {
        PrivateKey privateKey = this.getPrivateKey();
        PublicKey publicKey = this.getCert().getPublicKey();
        if (privateKey instanceof BCECPrivateKey && publicKey instanceof BCECPublicKey) {
            ECPrivateKeyParameters priKeyParam = BCECUtil.convertPrivateKeyToParameters((BCECPrivateKey)privateKey);
            ECPublicKeyParameters pubKeyParam = BCECUtil.convertPublicKeyToParameters((BCECPublicKey)publicKey);
            return BCECUtil.convertECPrivateKeyToSEC1(priKeyParam, pubKeyParam);
        }
        return privateKey.getEncoded();
    }

    public boolean isSM() {
        return GMObjectIdentifiers.sm2sign_with_sm3.toString().equals(this.cert.getSigAlgOID());
    }
}

