/*
 * Decompiled with CFR 0.152.
 */
package com.wangyin.aks.security.api;

import com.wangyin.aks.security.api.AksClientService;
import com.wangyin.aks.security.api.model.AlgEnum;
import com.wangyin.aks.security.api.model.CertDTO;
import com.wangyin.aks.security.api.model.DigestAlgEnum;
import com.wangyin.aks.security.api.model.ModeEnum;
import com.wangyin.aks.security.api.model.PaddingEnum;
import com.wangyin.aks.security.api.util.AsymmetricCryptoUtil;
import com.wangyin.aks.security.api.util.Base64;
import com.wangyin.aks.security.api.util.ByteUtil;
import com.wangyin.aks.security.api.util.CertUtil;
import com.wangyin.aks.security.api.util.DigestUtil;
import com.wangyin.aks.security.api.util.SymmetricCryptoUtil;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;

public class AksClientServiceImpl
implements AksClientService {
    @Override
    public byte[] encrypt(byte[] key, byte[] data) throws Exception {
        return SymmetricCryptoUtil.encrypt(data, key);
    }

    @Override
    public String encryptString(byte[] key, byte[] srcData) throws Exception {
        return SymmetricCryptoUtil.encryptString(srcData, key);
    }

    @Override
    public byte[] decrypt(byte[] key, byte[] envData) throws Exception {
        return SymmetricCryptoUtil.decrypt(envData, key);
    }

    @Override
    public byte[] encrypt(byte[] data, byte[] key, AlgEnum algEnum, ModeEnum modeEnum, PaddingEnum paddingEnum, byte[] iv) throws Exception {
        return SymmetricCryptoUtil.encrypt(data, key, algEnum, modeEnum, paddingEnum, iv);
    }

    @Override
    public byte[] decrypt(byte[] data, byte[] key, AlgEnum algEnum, ModeEnum modeEnum, PaddingEnum paddingEnum, byte[] iv) throws Exception {
        return SymmetricCryptoUtil.decrypt(data, key, algEnum, modeEnum, paddingEnum, iv);
    }

    @Override
    public byte[] public_cert_encrypt(String certB64, byte[] srcData) throws Exception {
        return AsymmetricCryptoUtil.encryptByCert(srcData, certB64);
    }

    @Override
    public byte[] public_encrypt(String publicKeyB64, byte[] srcData) throws Exception {
        return AsymmetricCryptoUtil.encryptByPubKey(srcData, publicKeyB64);
    }

    @Override
    public byte[] private_decrypt(byte[] privateKeyBytes, byte[] envData, boolean isSM) throws Exception {
        return AsymmetricCryptoUtil.decryptByPrivateKey(envData, privateKeyBytes, isSM);
    }

    @Override
    public byte[] p1_sign(byte[] privateKey, byte[] srcData, boolean isSM) throws Exception {
        String p1Data = AsymmetricCryptoUtil.p1_sign(srcData, privateKey, isSM);
        return Base64.decode(p1Data);
    }

    @Override
    public boolean p1_verify(String certB64, byte[] srcData, byte[] p1Data) throws Exception {
        return AsymmetricCryptoUtil.p1_verify(srcData, certB64, Base64.encode(p1Data));
    }

    @Override
    public String p7_sign(byte[] privateKey, String certB64, boolean attachFlag, byte[] srcData) throws Exception {
        return AsymmetricCryptoUtil.p7_sign(srcData, privateKey, certB64, attachFlag);
    }

    @Override
    public List<String> p7_verify(boolean attachFlag, String signedData, byte[] srcData) throws Exception {
        String verifyResult = AsymmetricCryptoUtil.p7_verify(srcData, signedData, attachFlag);
        String[] result = verifyResult.split("\\|");
        return Arrays.asList(result);
    }

    @Override
    public String encryptEnvelop(String certBase64, byte[] srcData) throws Exception {
        return AsymmetricCryptoUtil.encryptEnvelop(srcData, certBase64);
    }

    @Override
    public String decryptEnvelop(byte[] privateKey, String envelopB64) throws Exception {
        return Base64.encode(AsymmetricCryptoUtil.decryptEnvelop(envelopB64, privateKey));
    }

    @Override
    public String signEnvelop(String signCert, String password, String envelopCert, byte[] srcData) throws Exception {
        CertDTO certDto = CertUtil.getCertInfo(password, signCert);
        PrivateKey privateKey = certDto.getPriKey();
        X509Certificate cerx509 = certDto.getCert()[0];
        String signData = AsymmetricCryptoUtil.p7_sign(srcData, privateKey.getEncoded(), Base64.encode(cerx509.getEncoded()), true);
        String envelop = AsymmetricCryptoUtil.encryptEnvelop(Base64.decode(signData), envelopCert);
        return envelop;
    }

    @Override
    public List<String> verifyEnvelop(byte[] privateKeyBytes, String envelopData) throws Exception {
        byte[] signData = AsymmetricCryptoUtil.decryptEnvelop(envelopData, privateKeyBytes);
        System.out.println("\u89e3\u5f00\u4fe1\u5c01 " + Base64.encode(signData));
        String verifyResult = AsymmetricCryptoUtil.p7_verify(null, Base64.encode(signData), true);
        String[] result = verifyResult.split("\\|");
        return Arrays.asList(result);
    }

    @Override
    public String digest(DigestAlgEnum digestAlg, byte[] srcData) throws Exception {
        if (DigestAlgEnum.ALG_SM3.equals((Object)digestAlg)) {
            return DigestUtil.SM3(srcData);
        }
        return ByteUtil.bytesToHexString(this.digestByte(digestAlg, srcData));
    }

    byte[] digestByte(DigestAlgEnum digestAlg, byte[] srcData) throws Exception {
        MessageDigest md = MessageDigest.getInstance(digestAlg.getCode());
        return md.digest(srcData);
    }
}

