/*
 * Decompiled with CFR 0.152.
 */
package com.wangyin.aks.security.api;

import com.wangyin.aks.pdf.util.PKCS12Keystore;
import com.wangyin.aks.security.api.CryptoClientService;
import com.wangyin.aks.security.api.model.AlgEnum;
import com.wangyin.aks.security.api.model.DigestAlgEnum;
import com.wangyin.aks.security.api.model.ModeEnum;
import com.wangyin.aks.security.api.model.PaddingEnum;
import com.wangyin.aks.security.api.util.AsymmetricCryptoUtil;
import com.wangyin.aks.security.api.util.BCECUtil;
import com.wangyin.aks.security.api.util.Base64;
import com.wangyin.aks.security.api.util.ByteUtil;
import com.wangyin.aks.security.api.util.RSAUtil;
import com.wangyin.aks.security.api.util.SM2EnvelopUtil2;
import com.wangyin.aks.security.api.util.Sm2Util;
import com.wangyin.aks.security.api.util.SymmetricCryptoUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.crypto.Cipher;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;

public class CryptoClientServiceImpl
implements CryptoClientService {
    @Override
    public byte[] encrypt(byte[] data, byte[] key, AlgEnum algEnum, ModeEnum modeEnum, PaddingEnum paddingEnum, byte[] iv) throws Exception {
        return SymmetricCryptoUtil.encrypt(data, key, algEnum, modeEnum, paddingEnum, iv);
    }

    @Override
    public byte[] decrypt(byte[] data, byte[] key, AlgEnum algEnum, ModeEnum modeEnum, PaddingEnum paddingEnum, byte[] iv) throws Exception {
        return SymmetricCryptoUtil.decrypt(data, key, algEnum, modeEnum, paddingEnum, iv);
    }

    @Override
    public byte[] publicCertEncrypt(String certB64, byte[] srcData) throws Exception {
        return AsymmetricCryptoUtil.encryptByCert(srcData, certB64);
    }

    @Override
    public byte[] privateDecrypt(PKCS12Keystore keystore, byte[] encData) throws Exception {
        if (keystore.isSM()) {
            ECPrivateKeyParameters privateKeyParameters = BCECUtil.convertPrivateKeyToParameters((BCECPrivateKey)keystore.getPrivateKey());
            ASN1Sequence dataSequence = ASN1Sequence.getInstance((Object)encData);
            ASN1Integer c11 = (ASN1Integer)dataSequence.getObjectAt(0);
            ASN1Integer c12 = (ASN1Integer)dataSequence.getObjectAt(1);
            DEROctetString c2 = (DEROctetString)dataSequence.getObjectAt(3);
            DEROctetString c3 = (DEROctetString)dataSequence.getObjectAt(2);
            byte[] c11b = c11.getValue().toByteArray();
            byte[] c12b = c12.getValue().toByteArray();
            byte[] c2b = c2.getOctets();
            byte[] c3b = c3.getOctets();
            if (c11b.length == 33) {
                c11b = Arrays.copyOfRange(c11b, 1, c11b.length);
            }
            if (c12b.length == 33) {
                c12b = Arrays.copyOfRange(c12b, 1, c12b.length);
            }
            byte[] bytes = ByteUtil.joinBytes({4}, c11b, c12b, c2b, c3b);
            SM2Engine engine = new SM2Engine();
            engine.init(false, (CipherParameters)privateKeyParameters);
            return engine.processBlock(bytes, 0, bytes.length);
        }
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, keystore.getPrivateKey());
        return RSAUtil.doCipher(cipher, encData, false);
    }

    @Override
    public byte[] p1Sign(PKCS12Keystore keystore, byte[] srcData) throws Exception {
        if (keystore.isSM()) {
            ECPrivateKeyParameters privateKeyParameters = BCECUtil.convertPrivateKeyToParameters((BCECPrivateKey)keystore.getPrivateKey());
            return Sm2Util.sign(privateKeyParameters, srcData);
        }
        Signature signature = Signature.getInstance("SHA256withRSA");
        signature.initSign(keystore.getPrivateKey());
        signature.update(srcData);
        return signature.sign();
    }

    @Override
    public boolean p1Verify(String certB64, byte[] srcData, byte[] p1Data) throws Exception {
        return AsymmetricCryptoUtil.p1_verify(srcData, certB64, Base64.encode(p1Data));
    }

    @Override
    public String p7Sign(PKCS12Keystore keystore, boolean attachFlag, byte[] srcData) throws Exception {
        if (srcData == null) {
            throw new NullPointerException("Signed text cannot be NULL");
        }
        if (keystore.isSM()) {
            CMSProcessableByteArray msg = new CMSProcessableByteArray(srcData);
            JcaCertStore certs = new JcaCertStore(Collections.singletonList(keystore.getCert()));
            CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
            ContentSigner shaSigner = new JcaContentSignerBuilder("SM3WITHSM2").setProvider("BC").build(keystore.getPrivateKey());
            gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider("BC").build()).setDirectSignature(true).build(shaSigner, keystore.getCert()));
            gen.addCertificates((Store)certs);
            CMSSignedData sigData = gen.generate((CMSTypedData)msg, attachFlag);
            ContentInfo asn1Structure = sigData.toASN1Structure();
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dOut = new DEROutputStream((OutputStream)bOut);
            dOut.writeObject((ASN1Encodable)asn1Structure);
            return Base64.encode(bOut.toByteArray());
        }
        CMSProcessableByteArray msg = new CMSProcessableByteArray(srcData);
        JcaCertStore certs = new JcaCertStore(Collections.singletonList(keystore.getCert()));
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        ContentSigner shaSigner = new JcaContentSignerBuilder("SHA256withRSA").setProvider("BC").build(keystore.getPrivateKey());
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider("BC").build()).build(shaSigner, keystore.getCert()));
        gen.addCertificates((Store)certs);
        CMSSignedData sigData = gen.generate((CMSTypedData)msg, attachFlag);
        ContentInfo asn1Structure = sigData.toASN1Structure();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DEROutputStream dOut = new DEROutputStream((OutputStream)bOut);
        dOut.writeObject((ASN1Encodable)asn1Structure);
        return Base64.encode(bOut.toByteArray());
    }

    @Override
    public List<String> p7Verify(boolean attachFlag, String signedData, byte[] srcData) throws Exception {
        CMSSignedData sign;
        if (attachFlag) {
            sign = new CMSSignedData(Base64.decode(signedData));
        } else {
            CMSProcessableByteArray content = new CMSProcessableByteArray(srcData);
            sign = new CMSSignedData((CMSProcessable)content, Base64.decode(signedData));
        }
        Store certs = sign.getCertificates();
        SignerInformationStore signers = sign.getSignerInfos();
        Collection c = signers.getSigners();
        String[] result = new String[c.size() + 1];
        Iterator it = c.iterator();
        int size = 0;
        while (it.hasNext()) {
            SignerInformation signer = (SignerInformation)it.next();
            Collection certCollection = certs.getMatches((Selector)signer.getSID());
            Iterator certIt = certCollection.iterator();
            X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
            result[++size] = Base64.encode(cert.getEncoded());
            if (!signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build(cert))) continue;
            if (attachFlag) {
                result[0] = Base64.encode((byte[])sign.getSignedContent().getContent());
                continue;
            }
            result[0] = "";
        }
        if (result[0] == null) {
            return null;
        }
        return Arrays.asList(result);
    }

    @Override
    public String encryptEnvelop(String certBase64, byte[] srcData) throws Exception {
        X509Certificate cert = BCECUtil.getX509Certificate(Base64.decode(certBase64));
        if (GMObjectIdentifiers.sm2sign_with_sm3.toString().equals(cert.getSigAlgOID())) {
            return SM2EnvelopUtil2.encryptEnvelop(srcData, cert);
        }
        CMSProcessableByteArray dataArray = new CMSProcessableByteArray(srcData);
        CMSEnvelopedDataGenerator generator = new CMSEnvelopedDataGenerator();
        generator.addRecipientInfoGenerator((RecipientInfoGenerator)new JceKeyTransRecipientInfoGenerator(cert).setProvider("BC"));
        CMSEnvelopedData enveloped = generator.generate((CMSTypedData)dataArray, new JceCMSContentEncryptorBuilder(CMSAlgorithm.DES_EDE3_CBC).setProvider("BC").build());
        ContentInfo asn1Structure = enveloped.toASN1Structure();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DEROutputStream dOut = new DEROutputStream((OutputStream)bOut);
        dOut.writeObject((ASN1Encodable)asn1Structure);
        return Base64.encode(bOut.toByteArray());
    }

    @Override
    public String decryptEnvelop(PKCS12Keystore keystore, String envelopB64) throws Exception {
        if (keystore.isSM()) {
            byte[] bytes = SM2EnvelopUtil2.decryptEnvelop(envelopB64, keystore.getPrivateKey());
            return Base64.encode(bytes);
        }
        byte[] result = null;
        try {
            CMSEnvelopedData enveloped = new CMSEnvelopedData(Base64.decode(envelopB64));
            RecipientInformationStore recipient = enveloped.getRecipientInfos();
            PrivateKey privateK = keystore.getPrivateKey();
            if (recipient != null) {
                for (RecipientInformation information : recipient.getRecipients()) {
                    result = information.getContent((Recipient)new JceKeyTransEnvelopedRecipient(privateK).setProvider("BC"));
                }
            }
            return Base64.encode(result);
        }
        catch (CMSException e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public String signEnvelop(PKCS12Keystore keystore, String envelopCert, byte[] srcData) throws Exception {
        String s = this.p7Sign(keystore, true, srcData);
        return this.encryptEnvelop(envelopCert, Base64.decode(s));
    }

    @Override
    public List<String> verifyEnvelop(PKCS12Keystore keystore, String envelopData) throws Exception {
        String s = this.decryptEnvelop(keystore, envelopData);
        return this.p7Verify(true, s, null);
    }

    @Override
    public String digest(DigestAlgEnum digestAlg, byte[] srcData) throws Exception {
        if (DigestAlgEnum.ALG_SM3.equals((Object)digestAlg)) {
            SM3Digest digest = new SM3Digest();
            digest.update(srcData, 0, srcData.length);
            byte[] hash = new byte[digest.getDigestSize()];
            digest.doFinal(hash, 0);
            return ByteUtil.bytesToHexString(hash);
        }
        MessageDigest md = MessageDigest.getInstance(digestAlg.getCode());
        byte[] hash = md.digest(srcData);
        return ByteUtil.bytesToHexString(hash);
    }
}

