/*
 * Decompiled with CFR 0.152.
 */
package com.wangyin.aks.security.api;

import com.wangyin.aks.pdf.util.PKCS12Keystore;
import com.wangyin.aks.security.api.util.AsymmetricCryptoUtil;
import com.wangyin.aks.security.api.util.Base64;
import com.wangyin.aks.security.api.util.JSON;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Null;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9ECPoint;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.engines.DESedeEngine;
import org.bouncycastle.crypto.engines.RC2Engine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.bouncycastle.jcajce.provider.asymmetric.util.KeyUtil;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.custom.gm.SM2P256V1Curve;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.PKCS12MacCalculatorBuilder;
import org.bouncycastle.pkcs.PKCS12PfxPdu;
import org.bouncycastle.pkcs.PKCS12PfxPduBuilder;
import org.bouncycastle.pkcs.PKCS12SafeBag;
import org.bouncycastle.pkcs.PKCSException;
import org.bouncycastle.pkcs.bc.BcPKCS12MacCalculatorBuilder;
import org.bouncycastle.pkcs.bc.BcPKCS12PBEOutputEncryptorBuilder;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.bouncycastle.pkcs.jcajce.JcaPKCS12SafeBagBuilder;

public class GMHelper {
    private static final Logger LOGGER;
    private static final SM2P256V1Curve CURVE;
    private static final BigInteger SM2_ECC_P;
    private static final BigInteger SM2_ECC_A;
    private static final BigInteger SM2_ECC_B;
    private static final BigInteger SM2_ECC_N;
    private static final BigInteger SM2_ECC_H;
    private static final BigInteger SM2_ECC_GX;
    private static final BigInteger SM2_ECC_GY;
    private static final org.bouncycastle.math.ec.ECPoint G_POINT;
    private static final ECDomainParameters DOMAIN_PARAMS;
    private static final EllipticCurve JDK_CURVE;
    private static final ECPoint JDK_G_POINT;
    private static final ECParameterSpec JDK_EC_SPEC;
    private static final String CertFile;
    private final boolean isLog;

    public GMHelper() {
        this(true);
    }

    public GMHelper(boolean isLog) {
        this.isLog = isLog;
    }

    public static void main(String[] args) throws Exception {
        String url = args[0];
        String authCode = args[1];
        String filepath = args[2];
        String password = args[3];
        byte[] fileBytes = null;
        try {
            fileBytes = GMHelper.readFile(filepath);
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        if (fileBytes != null) {
            PKCS12Keystore keystore = PKCS12Keystore.getInstance(fileBytes, password);
            PrivateKey privateKey = keystore.getPrivateKey();
            PublicKey publicKey = keystore.getCert().getPublicKey();
            GMHelper helper = new GMHelper();
            byte[][] bytes = helper.p10(privateKey, publicKey);
            String csr = new String(bytes[1]);
            byte[] cert = GMHelper.cert(url, authCode, csr);
            byte[] pfx = helper.pfx(cert, bytes[0], password);
            File oldFile = new File(filepath);
            boolean b = oldFile.renameTo(new File(filepath + "." + System.currentTimeMillis() + ".bak"));
            if (!b) {
                throw new RuntimeException("Old file rename failed, and New file will not be write.");
            }
            GMHelper.writeFile(filepath, pfx);
        } else {
            GMHelper helper = new GMHelper();
            byte[][] bytes = helper.p10();
            String csr = new String(bytes[1]);
            byte[] cert = GMHelper.cert(url, authCode, csr);
            byte[] pfx = helper.pfx(cert, bytes[0], password);
            GMHelper.writeFile(filepath, pfx);
        }
    }

    private static byte[] cert(String url, String authCode, String csr) throws Exception {
        String gatewayCert = GMHelper.gatewayCert();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("ET", "P");
        String payload = "{\"authCode\":\"" + authCode + "\",\"p10\":\"" + csr + "\"}";
        payload = AsymmetricCryptoUtil.encryptEnvelop(payload.getBytes(), gatewayCert);
        String data = GMHelper.connect(new URL(url), "POST", headers, payload);
        String sign = data.substring(0, 344);
        data = data.substring(344);
        boolean verify = AsymmetricCryptoUtil.p1_verify(data.getBytes(), gatewayCert, sign);
        if (!verify) {
            throw new RuntimeException("Response verify failed.");
        }
        CommonResponse response = JSON.parseObject(data, CommonResponse.class);
        if (response == null || response.getCode() == null) {
            throw new RuntimeException("Response is empty or can't be resolved.");
        }
        if (response.getCode() != 200) {
            throw new RuntimeException(response.getMessage());
        }
        String cert = response.getData();
        return Base64.decode(cert);
    }

    private static String connect(URL url, String method, Map<String, String> headers, String payload) throws Exception {
        String line;
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod(method);
        conn.setConnectTimeout(5000);
        conn.setReadTimeout(5000);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                conn.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        if (payload != null) {
            OutputStream out = conn.getOutputStream();
            out.write(payload.getBytes());
            out.close();
        }
        StringBuilder sb = new StringBuilder();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
            while ((line = in.readLine()) != null) {
                sb.append(line);
            }
            in.close();
            return sb.toString();
        }
        catch (Exception e) {
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getErrorStream()));
            while ((line = in.readLine()) != null) {
                sb.append(line);
            }
            in.close();
            throw new RuntimeException(sb.toString(), e);
        }
    }

    public void p10(String priKeyFilePath, String csrFilePath) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, OperatorCreationException, IOException {
        byte[][] bytes = this.p10();
        GMHelper.writeFile(priKeyFilePath, bytes[0]);
        GMHelper.writeFile(csrFilePath, bytes[1]);
    }

    public byte[][] p10() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, OperatorCreationException, IOException {
        KeyPair subKP = GMHelper.generateKeyPair();
        return this.p10(subKP.getPrivate(), subKP.getPublic());
    }

    public byte[][] p10(PrivateKey privateKey, PublicKey publicKey) throws OperatorCreationException, IOException {
        ECPrivateKeyParameters priKeyParam = GMHelper.convertPrivateKeyToParameters((BCECPrivateKey)privateKey);
        ECPublicKeyParameters pubKeyParam = GMHelper.convertPublicKeyToParameters((BCECPublicKey)publicKey);
        byte[] derPriKey = GMHelper.convertECPrivateKeyToSEC1(priKeyParam, pubKeyParam);
        String p = Base64.encode(derPriKey);
        if (this.isLog) {
            LOGGER.info("PRI (base64): " + p);
        }
        X500Name subDN = GMHelper.buildSubjectDN();
        SM2PublicKey sm2SubPub = new SM2PublicKey(publicKey.getAlgorithm(), (BCECPublicKey)publicKey);
        byte[] csr = GMHelper.createCSR(subDN, sm2SubPub, privateKey, "SM3withSM2").getEncoded();
        PKCS10CertificationRequest request = new PKCS10CertificationRequest(csr);
        String s = Base64.encode(request.getEncoded());
        if (this.isLog) {
            LOGGER.info("CSR: " + s);
        }
        return new byte[][]{derPriKey, s.getBytes()};
    }

    public void pfx(String certFilePath, String sec1PriKeyFilePath, String password, String pfxFilePath) throws CertificateException, NoSuchProviderException, NoSuchAlgorithmException, IOException, InvalidKeySpecException, PKCSException {
        byte[] cert = GMHelper.readFile(certFilePath);
        cert = Base64.decode(new String(cert));
        byte[] sec1PriKey = GMHelper.readFile(sec1PriKeyFilePath);
        byte[] pfx = this.pfx(cert, sec1PriKey, password);
        GMHelper.writeFile(pfxFilePath, pfx);
    }

    public byte[] pfx(byte[] cert, byte[] sec1PriKey, String password) throws CertificateException, NoSuchProviderException, NoSuchAlgorithmException, IOException, InvalidKeySpecException, PKCSException {
        X509Certificate x509Certificate = GMHelper.getX509Certificate(new ByteArrayInputStream(cert));
        PublicKey subPub = x509Certificate.getPublicKey();
        BCECPrivateKey privateKey = GMHelper.convertSEC1ToBCECPrivateKey(sec1PriKey);
        PKCS12PfxPdu pfx = GMHelper.makePfx((PrivateKey)privateKey, subPub, x509Certificate, password);
        byte[] encoded = pfx.getEncoded("DER");
        if (this.isLog) {
            LOGGER.info("PFX (base64): " + Base64.encode(encoded));
        }
        return encoded;
    }

    private static KeyPair generateKeyPair() throws NoSuchProviderException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        ECDomainParameters domainParameters = DOMAIN_PARAMS;
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("EC", "BC");
        org.bouncycastle.jce.spec.ECParameterSpec parameterSpec = new org.bouncycastle.jce.spec.ECParameterSpec(domainParameters.getCurve(), domainParameters.getG(), domainParameters.getN(), domainParameters.getH());
        kpg.initialize((AlgorithmParameterSpec)parameterSpec, new SecureRandom());
        return kpg.generateKeyPair();
    }

    private static X500Name buildSubjectDN() {
        X500NameBuilder builder = new X500NameBuilder(BCStyle.INSTANCE);
        builder.addRDN(BCStyle.C, "");
        builder.addRDN(BCStyle.O, "");
        builder.addRDN(BCStyle.OU, "");
        builder.addRDN(BCStyle.CN, "");
        builder.addRDN(BCStyle.EmailAddress, "");
        return builder.build();
    }

    private static PKCS10CertificationRequest createCSR(X500Name subject, SM2PublicKey pubKey, PrivateKey priKey, String signAlgo) throws OperatorCreationException {
        JcaPKCS10CertificationRequestBuilder csrBuilder = new JcaPKCS10CertificationRequestBuilder(subject, (PublicKey)((Object)pubKey));
        ContentSigner signerBuilder = new JcaContentSignerBuilder(signAlgo).setProvider("BC").build(priKey);
        return csrBuilder.build(signerBuilder);
    }

    private static ECPublicKeyParameters convertPublicKeyToParameters(BCECPublicKey ecPubKey) {
        org.bouncycastle.jce.spec.ECParameterSpec parameterSpec = ecPubKey.getParameters();
        ECDomainParameters domainParameters = new ECDomainParameters(parameterSpec.getCurve(), parameterSpec.getG(), parameterSpec.getN(), parameterSpec.getH());
        return new ECPublicKeyParameters(ecPubKey.getQ(), domainParameters);
    }

    private static ECPrivateKeyParameters convertPrivateKeyToParameters(BCECPrivateKey ecPriKey) {
        org.bouncycastle.jce.spec.ECParameterSpec parameterSpec = ecPriKey.getParameters();
        ECDomainParameters domainParameters = new ECDomainParameters(parameterSpec.getCurve(), parameterSpec.getG(), parameterSpec.getN(), parameterSpec.getH());
        return new ECPrivateKeyParameters(ecPriKey.getD(), domainParameters);
    }

    private static byte[] convertECPrivateKeyToSEC1(ECPrivateKeyParameters priKey, ECPublicKeyParameters pubKey) throws IOException {
        byte[] pkcs8Bytes = GMHelper.convertECPrivateKeyToPKCS8(priKey, pubKey);
        PrivateKeyInfo pki = PrivateKeyInfo.getInstance((Object)pkcs8Bytes);
        ASN1Encodable encodable = pki.parsePrivateKey();
        ASN1Primitive primitive = encodable.toASN1Primitive();
        return primitive.getEncoded();
    }

    private static byte[] convertECPrivateKeyToPKCS8(ECPrivateKeyParameters priKey, ECPublicKeyParameters pubKey) {
        ECDomainParameters domainParams = priKey.getParameters();
        org.bouncycastle.jce.spec.ECParameterSpec spec = new org.bouncycastle.jce.spec.ECParameterSpec(domainParams.getCurve(), domainParams.getG(), domainParams.getN(), domainParams.getH());
        BCECPublicKey publicKey = null;
        if (pubKey != null) {
            publicKey = new BCECPublicKey("EC", pubKey, spec, BouncyCastleProvider.CONFIGURATION);
        }
        BCECPrivateKey privateKey = new BCECPrivateKey("EC", priKey, publicKey, spec, BouncyCastleProvider.CONFIGURATION);
        return privateKey.getEncoded();
    }

    private static BCECPrivateKey convertSEC1ToBCECPrivateKey(byte[] sec1Key) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException, IOException {
        PKCS8EncodedKeySpec peks = new PKCS8EncodedKeySpec(GMHelper.convertECPrivateKeySEC1ToPKCS8(sec1Key));
        KeyFactory kf = KeyFactory.getInstance("EC", "BC");
        return (BCECPrivateKey)kf.generatePrivate(peks);
    }

    private static byte[] convertECPrivateKeySEC1ToPKCS8(byte[] sec1Key) throws IOException {
        X962Parameters params = GMHelper.getDomainParametersFromName(JDK_EC_SPEC, false);
        DEROctetString privKey = new DEROctetString(sec1Key);
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)new ASN1Integer(0L));
        v.add((ASN1Encodable)new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)params));
        v.add((ASN1Encodable)privKey);
        DERSequence ds = new DERSequence(v);
        return ds.getEncoded("DER");
    }

    private static X962Parameters getDomainParametersFromName(ECParameterSpec ecSpec, boolean withCompression) {
        X962Parameters params;
        if (ecSpec instanceof ECNamedCurveSpec) {
            ASN1ObjectIdentifier curveOid = ECUtil.getNamedCurveOid((String)((ECNamedCurveSpec)ecSpec).getName());
            if (curveOid == null) {
                curveOid = new ASN1ObjectIdentifier(((ECNamedCurveSpec)ecSpec).getName());
            }
            params = new X962Parameters(curveOid);
        } else if (ecSpec == null) {
            params = new X962Parameters((ASN1Null)DERNull.INSTANCE);
        } else {
            ECCurve curve = EC5Util.convertCurve((EllipticCurve)ecSpec.getCurve());
            X9ECParameters ecP = new X9ECParameters(curve, EC5Util.convertPoint((ECCurve)curve, (ECPoint)ecSpec.getGenerator(), (boolean)withCompression), ecSpec.getOrder(), BigInteger.valueOf(ecSpec.getCofactor()), ecSpec.getCurve().getSeed());
            params = new X962Parameters(ecP);
        }
        return params;
    }

    private static X509Certificate getX509Certificate(InputStream is) throws CertificateException, NoSuchProviderException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
        return (X509Certificate)cf.generateCertificate(is);
    }

    private static PKCS12PfxPdu makePfx(PrivateKey privKey, PublicKey pubKey, X509Certificate cert, String passwd) throws NoSuchAlgorithmException, IOException, PKCSException {
        JcaX509ExtensionUtils extUtils = new JcaX509ExtensionUtils();
        JcaPKCS12SafeBagBuilder eeCertBagBuilder = new JcaPKCS12SafeBagBuilder(cert);
        eeCertBagBuilder.addBagAttribute(PKCSObjectIdentifiers.pkcs_9_at_friendlyName, (ASN1Encodable)new DERBMPString("User Key"));
        eeCertBagBuilder.addBagAttribute(PKCSObjectIdentifiers.pkcs_9_at_localKeyId, (ASN1Encodable)extUtils.createSubjectKeyIdentifier(pubKey));
        char[] passwdChars = passwd.toCharArray();
        JcaPKCS12SafeBagBuilder keyBagBuilder = new JcaPKCS12SafeBagBuilder(privKey, new BcPKCS12PBEOutputEncryptorBuilder(PKCSObjectIdentifiers.pbeWithSHAAnd3_KeyTripleDES_CBC, (BlockCipher)new CBCBlockCipher((BlockCipher)new DESedeEngine())).build(passwdChars));
        keyBagBuilder.addBagAttribute(PKCSObjectIdentifiers.pkcs_9_at_friendlyName, (ASN1Encodable)new DERBMPString("User Key"));
        keyBagBuilder.addBagAttribute(PKCSObjectIdentifiers.pkcs_9_at_localKeyId, (ASN1Encodable)extUtils.createSubjectKeyIdentifier(pubKey));
        PKCS12PfxPduBuilder pfxPduBuilder = new PKCS12PfxPduBuilder();
        PKCS12SafeBag[] certs = new PKCS12SafeBag[]{eeCertBagBuilder.build()};
        pfxPduBuilder.addEncryptedData(new BcPKCS12PBEOutputEncryptorBuilder(PKCSObjectIdentifiers.pbeWithSHAAnd40BitRC2_CBC, (BlockCipher)new CBCBlockCipher((BlockCipher)new RC2Engine())).build(passwdChars), certs);
        pfxPduBuilder.addData(keyBagBuilder.build());
        return pfxPduBuilder.build((PKCS12MacCalculatorBuilder)new BcPKCS12MacCalculatorBuilder(), passwdChars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFile(String filePath, byte[] data) throws IOException {
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(filePath, "rw");
            raf.write(data);
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readFile(String filePath) throws IOException {
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(filePath, "r");
            byte[] data = new byte[(int)raf.length()];
            raf.read(data);
            byte[] byArray = data;
            return byArray;
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
    }

    private static String gatewayCert() throws IOException {
        if (CertFile == null) {
            return "MIID9TCCAt2gAwIBAgIUc7l6tm4Zh0DNz7SZZf1AAXwhT5owDQYJKoZIhvcNAQELBQAwXjEYMBYGA1UEAwwPV2FuZ1lpbiBVc2VyIENBMR8wHQYDVQQLDBZXYW5nWWluIFNlY3VyaXR5Q2VudGVyMRQwEgYDVQQKDAtXYW5nWWluLmNvbTELMAkGA1UEBhMCQ04wHhcNMjAxMTE0MjAwMDM2WhcNMjExMTE0MjAwMDM2WjBBMSEwHwYDVQQDDBhBS1MoUFVCTElDKShBS1MwMDAwMEFLUykxDzANBgNVBAsMBmpyIHRvcDELMAkGA1UECgwCamQwggEgMA0GCSqGSIb3DQEBAQUAA4IBDQAwggEIAoIBAQDhh5RZ2uUgdO6b0+L811FyD3zWx9hYt5HB+kHmkimqNzlRe9ifiLZF155hf3rnGaJ/HG0ryuoKuGDx+Csl+7KQzGIFaU+Dh92Od0ALUu4OZ1BQadCLK0GmoYt9E0JtShvPrUEM0HWbqbOv9DOl2YbP/N/byaX9wqEdUc6xLLNYDhF+nGu3mVDu5fmLFn2C1ztucnMRmbUQweA/75K9+D2Ze8NT+wNqhpoMFUPvwE94tPvB1fcYYXPy07WiQXPe7KR3WmsRgjMAEbYrD1VIV6qNwXFOd7h8/vK807nPCaPMYPi+8cpRQ653NMU4D/FZpY2CnPNZfH4vLVPrN2r9EK7dAgEDo4HJMIHGMAkGA1UdEwQCMAAwCwYDVR0PBAQDAgbAMGwGA1UdHwRlMGMwYaBfoF2GW2h0dHA6Ly90b3BjYS5kLmNoaW5hYmFuay5jb20uY24vcHVibGljL2l0cnVzY3JsP0NBPTFFRTQ1QjcxNkQwOUE0OTI4MkIxMzQ2QTJDQzNDNjI3MzExMzgwRUIwHwYDVR0jBBgwFoAUCKxvAe67vsOUVzpp1dx/r34ctOAwHQYDVR0OBBYEFNgDV7dlTVRcpCpJD+6jsxM7PgFSMA0GCSqGSIb3DQEBCwUAA4IBAQBIAAYXEJm/cSC0SGodQEBltlllse7nGujml6LulpTUnmJmcYw3rP4E9WQ28uguEVhDL97j35FjoBtAa5AioEVC5FdYbI7mpCy3XfVR7sbQhOSVhSBnbz2pT9qK9Dv5S1l9iPnUnMzU+bsQ7qHLv9Ga8uWmHjh/RYRmrv90L1/A/UWb8SXSZbr1jb51pnD5zuOi8hBSkK8DfbXiF4GrLtGX5dEzRGAh3h2KzIZ3G4uiF0ptZrMol+P7R8SLMWEETy2cq3sgH7JyB0Ozx43Uh4LfflHDQ+mzoqULxFHPwFQ2Me7BgbJEiEgCe2Fp/Qm6KIo0R0HBk49g4vrMTyQwsz2w";
        }
        return new String(GMHelper.readFile(CertFile));
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        LOGGER = Logger.getLogger(GMHelper.class.getName());
        CURVE = new SM2P256V1Curve();
        SM2_ECC_P = CURVE.getQ();
        SM2_ECC_A = CURVE.getA().toBigInteger();
        SM2_ECC_B = CURVE.getB().toBigInteger();
        SM2_ECC_N = CURVE.getOrder();
        SM2_ECC_H = CURVE.getCofactor();
        SM2_ECC_GX = new BigInteger("32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7", 16);
        SM2_ECC_GY = new BigInteger("BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0", 16);
        G_POINT = CURVE.createPoint(SM2_ECC_GX, SM2_ECC_GY);
        DOMAIN_PARAMS = new ECDomainParameters((ECCurve)CURVE, G_POINT, SM2_ECC_N, SM2_ECC_H);
        JDK_CURVE = new EllipticCurve(new ECFieldFp(SM2_ECC_P), SM2_ECC_A, SM2_ECC_B);
        JDK_G_POINT = new ECPoint(G_POINT.getAffineXCoord().toBigInteger(), G_POINT.getAffineYCoord().toBigInteger());
        JDK_EC_SPEC = new ECParameterSpec(JDK_CURVE, JDK_G_POINT, SM2_ECC_N, SM2_ECC_H.intValue());
        CertFile = System.getProperty("aks.gateway.certfile");
    }

    private static class CommonResponse {
        private Integer code;
        private String message;
        private String data;

        private CommonResponse() {
        }

        public Integer getCode() {
            return this.code;
        }

        public void setCode(Integer code) {
            this.code = code;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getData() {
            return this.data;
        }

        public void setData(String data) {
            this.data = data;
        }

        public String toString() {
            return "SecurityCertDownloadResponse{code=" + this.code + ", message='" + this.message + '\'' + ", data='" + this.data + '\'' + '}';
        }
    }

    private static class SM2PublicKey
    extends BCECPublicKey {
        public static final ASN1ObjectIdentifier ID_SM2_PUBKEY_PARAM = new ASN1ObjectIdentifier("1.2.156.10197.1.301");
        private boolean withCompression = false;

        public SM2PublicKey(BCECPublicKey key) {
            super(key.getAlgorithm(), key);
        }

        public SM2PublicKey(String algorithm, BCECPublicKey key) {
            super(algorithm, key);
        }

        public byte[] getEncoded() {
            ASN1OctetString p = ASN1OctetString.getInstance((Object)new X9ECPoint(this.getQ(), this.withCompression).toASN1Primitive());
            SubjectPublicKeyInfo info = new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)ID_SM2_PUBKEY_PARAM), p.getOctets());
            return KeyUtil.getEncodedSubjectPublicKeyInfo((SubjectPublicKeyInfo)info);
        }

        public void setPointFormat(String style) {
            this.withCompression = !"UNCOMPRESSED".equalsIgnoreCase(style);
        }
    }
}

