/*
 * Decompiled with CFR 0.152.
 */
package com.wangyin.aks.security.api.model;

public enum AlgEnum {
    ALG_SM4(16, 5, "\u56fd\u5bc6SM4\u52a0\u5bc6\u7b97\u6cd5", "SM4", 16),
    ALG_AES(32, 2, "\u6807\u51c6AES128\u52a0\u5bc6\u7b97\u6cd5", "AES", 16),
    ALG_AES192(48, 3, "\u6807\u51c6AES192\u52a0\u5bc6\u7b97\u6cd5", "AES", 24),
    ALG_AES256(64, 4, "\u6807\u51c6AES256\u52a0\u5bc6\u7b97\u6cd5", "AES", 32),
    ALG_RSA1024(80, 11, "RSA1024\u975e\u5bf9\u79f0\u7b97\u6cd5", "RSA", 128),
    ALG_RSA2048(96, 12, "RSA2048\u975e\u5bf9\u79f0\u7b97\u6cd5", "RSA", 256),
    ALG_SM2(112, 14, "SM2\u975e\u5bf9\u79f0\u7b97\u6cd5", "SM2", 256);

    private byte code;
    private int value;
    private String desc = null;
    private String alg = null;
    private int length;

    private AlgEnum(byte code, int value, String desc, String alg, int length) {
        this.code = code;
        this.value = value;
        this.desc = desc;
        this.alg = alg;
        this.length = length;
    }

    public byte getCode() {
        return this.code;
    }

    public int getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getAlg() {
        return this.alg;
    }

    public int getLength() {
        return this.length;
    }

    public static AlgEnum getAlgEnum(byte b) {
        for (AlgEnum type : AlgEnum.values()) {
            if (type.code != b) continue;
            return type;
        }
        return null;
    }
}

