/*
 * Decompiled with CFR 0.152.
 */
package com.wangyin.aks.security.api.util;

import com.wangyin.aks.pdf.util.PKCS12Keystore;
import com.wangyin.aks.security.api.util.BCBase;
import com.wangyin.aks.security.api.util.BCECUtil;
import com.wangyin.aks.security.api.util.BCECUtil2;
import com.wangyin.aks.security.api.util.ByteUtil;
import com.wangyin.aks.security.api.util.EnvelopUtil;
import com.wangyin.aks.security.api.util.RSAUtil;
import com.wangyin.aks.security.api.util.SM2EnvelopUtil2;
import com.wangyin.aks.security.api.util.Sm2EncryptResult;
import com.wangyin.aks.security.api.util.Sm2Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.xml.bind.DatatypeConverter;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;

public class AsymmetricCryptoUtil
extends BCBase {
    public static byte[] encryptByCert(byte[] data, String certB64) throws Exception {
        Certificate certificate = AsymmetricCryptoUtil.convertCertificate(certB64);
        if (GMObjectIdentifiers.sm2sign_with_sm3.toString().equals(certificate.getSignatureAlgorithm().getAlgorithm().toString())) {
            byte[] sm2Cipher = Sm2Util.encryt(AsymmetricCryptoUtil.populateFromPubKeyInfo(certificate.getSubjectPublicKeyInfo()), data);
            Sm2EncryptResult sm2EncryptResult = Sm2Util.parseSm2CipherText(sm2Cipher);
            BigInteger bigInteger1 = new BigInteger(ByteUtil.copy(sm2EncryptResult.getC1(), 1, 32));
            BigInteger bigInteger2 = new BigInteger(ByteUtil.copy(sm2EncryptResult.getC1(), 33, 32));
            ASN1Integer c11 = new ASN1Integer(bigInteger1);
            ASN1Integer c12 = new ASN1Integer(bigInteger2);
            DEROctetString c2 = new DEROctetString(sm2EncryptResult.getC2());
            DEROctetString c3 = new DEROctetString(sm2EncryptResult.getC3());
            ASN1EncodableVector vector = new ASN1EncodableVector();
            vector.add((ASN1Encodable)c11);
            vector.add((ASN1Encodable)c12);
            vector.add((ASN1Encodable)c3);
            vector.add((ASN1Encodable)c2);
            return new DERSequence(vector).getEncoded();
        }
        return DatatypeConverter.parseBase64Binary((String)RSAUtil.encryptByPublicKey(data, certificate.getSubjectPublicKeyInfo().getEncoded()));
    }

    public static byte[] encryptByPubKey(byte[] data, String pubKeyB64) throws Exception {
        return DatatypeConverter.parseBase64Binary((String)RSAUtil.encryptByPublicKey(data, pubKeyB64));
    }

    public static byte[] decryptByPrivateKey(byte[] data, byte[] privateKeyBytes, boolean isSM) throws Exception {
        if (isSM) {
            BCECPrivateKey bcecPrivateKey = BCECUtil2.convertSEC1ToBCECPrivateKey(privateKeyBytes);
            ECPrivateKeyParameters privateKeyParameters = BCECUtil.convertPrivateKeyToParameters(bcecPrivateKey);
            ASN1Sequence dataSequence = ASN1Sequence.getInstance((Object)data);
            ASN1Integer c11 = (ASN1Integer)dataSequence.getObjectAt(0);
            ASN1Integer c12 = (ASN1Integer)dataSequence.getObjectAt(1);
            DEROctetString c2 = (DEROctetString)dataSequence.getObjectAt(3);
            DEROctetString c3 = (DEROctetString)dataSequence.getObjectAt(2);
            byte[] c11b = c11.getValue().toByteArray();
            byte[] c12b = c12.getValue().toByteArray();
            byte[] c2b = c2.getOctets();
            byte[] c3b = c3.getOctets();
            if (c11b.length == 33) {
                c11b = Arrays.copyOfRange(c11b, 1, c11b.length);
            }
            if (c12b.length == 33) {
                c12b = Arrays.copyOfRange(c12b, 1, c12b.length);
            }
            return Sm2Util.decrypt(privateKeyParameters, ByteUtil.joinBytes({4}, c11b, c12b, c2b, c3b));
        }
        return RSAUtil.decryptByPrivateKey(data, privateKeyBytes);
    }

    public static String p1_sign(byte[] data, byte[] keyBytes, boolean isSM) throws Exception {
        if (isSM) {
            BCECPrivateKey bcecPrivateKey = BCECUtil2.convertSEC1ToBCECPrivateKey(keyBytes);
            ECPrivateKeyParameters privateKeyParameters = BCECUtil.convertPrivateKeyToParameters(bcecPrivateKey);
            return DatatypeConverter.printBase64Binary((byte[])Sm2Util.sign(privateKeyParameters, data));
        }
        return RSAUtil.sign(data, keyBytes);
    }

    public static boolean p1_verify(byte[] data, String certB64, String sign) throws Exception {
        Certificate certificate = AsymmetricCryptoUtil.convertCertificate(certB64);
        if (GMObjectIdentifiers.sm2sign_with_sm3.toString().equals(certificate.getSignatureAlgorithm().getAlgorithm().toString())) {
            return Sm2Util.verify(AsymmetricCryptoUtil.populateFromPubKeyInfo(certificate.getSubjectPublicKeyInfo()), data, DatatypeConverter.parseBase64Binary((String)sign));
        }
        return RSAUtil.verify(data, certificate.getSubjectPublicKeyInfo().getEncoded(), sign);
    }

    public static String p7_sign(byte[] data, byte[] privateKeyBytes, String certB64, boolean isAttach) throws Exception {
        return RSAUtil.signP7(data, privateKeyBytes, certB64, isAttach);
    }

    public static String p7_verify(byte[] data, String signedData, boolean isAttach) throws Exception {
        String[] verify = RSAUtil.verifyP7(data, signedData, isAttach);
        String result = verify[0];
        if (result == null) {
            return null;
        }
        for (int i = 1; i < verify.length; ++i) {
            result = result + "|" + verify[i];
        }
        return result;
    }

    public static String p7_sign_gm(byte[] data, byte[] pfx, String password, boolean isAttach) throws Exception {
        return Sm2Util.signP7(data, pfx, password, isAttach);
    }

    public static String p7_verify_gm(byte[] data, String signedData, boolean isAttach) throws Exception {
        String[] verify = Sm2Util.verifyP7(data, signedData, isAttach);
        String result = verify[0];
        if (result == null) {
            return null;
        }
        for (int i = 1; i < verify.length; ++i) {
            result = result + "|" + verify[i];
        }
        return result;
    }

    public static String encryptEnvelop(byte[] data, String certB64) throws Exception {
        return EnvelopUtil.encryptEnvelop(data, certB64);
    }

    public static byte[] decryptEnvelop(String envelopB64, byte[] privateKeyBytes) throws Exception {
        return EnvelopUtil.decryptEnvelop(envelopB64, privateKeyBytes);
    }

    public static String encryptEnvelop_gm(byte[] data, String certB64) throws Exception {
        X509Certificate cert = BCECUtil.getX509Certificate(DatatypeConverter.parseBase64Binary((String)certB64));
        return SM2EnvelopUtil2.encryptEnvelop(data, cert);
    }

    public static String decryptEnvelop_gm(String envelopB64, byte[] pfx, String password) throws Exception {
        PKCS12Keystore keystore = PKCS12Keystore.getInstance(pfx, password);
        byte[] bytes = SM2EnvelopUtil2.decryptEnvelop(envelopB64, keystore.getPrivateKey());
        return DatatypeConverter.printBase64Binary((byte[])bytes);
    }

    public static Certificate convertCertificate(String certB64) throws Exception {
        ByteArrayInputStream inStream = new ByteArrayInputStream(DatatypeConverter.parseBase64Binary((String)certB64));
        ASN1InputStream asn1InputStream = new ASN1InputStream((InputStream)inStream);
        ASN1Sequence asn1Sequence = (ASN1Sequence)asn1InputStream.readObject();
        return Certificate.getInstance((Object)asn1Sequence);
    }

    private static ECPublicKeyParameters populateFromPubKeyInfo(SubjectPublicKeyInfo info) throws IOException {
        return (ECPublicKeyParameters)PublicKeyFactory.createKey((SubjectPublicKeyInfo)info);
    }
}

