/*
 * Decompiled with CFR 0.152.
 */
package com.wangyin.aks.security.api.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import org.apache.commons.codec.binary.Hex;

public class ByteUtil {
    public static byte[] intToByteArray(int i) {
        byte[] result = new byte[]{(byte)(i >> 24 & 0xFF), (byte)(i >> 16 & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i & 0xFF)};
        return result;
    }

    public static int byteToInt(byte[] b) {
        int mask = 255;
        int temp = 0;
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            n <<= 8;
            temp = b[i] & mask;
            n |= temp;
        }
        return n;
    }

    public static byte[] copy(byte[] in, int begin, int length) {
        int len = in.length;
        if (len < length || len < begin || len < length - begin) {
            return null;
        }
        byte[] out = new byte[length];
        System.arraycopy(in, begin, out, 0, length);
        return out;
    }

    public static byte[][] getBytes(byte[] in, int len) {
        int length = in.length;
        int count = 0;
        count = length % len == 0 ? length / len : length / len + 1;
        byte[][] out = new byte[count][];
        int begin = 0;
        for (int i = 0; i < count; ++i) {
            if (length < len) {
                len = length;
            }
            out[i] = ByteUtil.copy(in, begin, len);
            begin += len;
            length -= len;
        }
        return out;
    }

    public static byte[] copyLast8Byte(byte[] in) {
        byte[] out = new byte[8];
        System.arraycopy(in, in.length - 8, out, 0, 8);
        return out;
    }

    public static byte[] joinBytes(byte[] ... in) {
        int length = in.length;
        int sum = 0;
        for (int i = 0; i < length; ++i) {
            sum += in[i].length;
        }
        byte[] out = new byte[sum];
        int begin = 0;
        for (int i = 0; i < length; ++i) {
            int len = in[i].length;
            System.arraycopy(in[i], 0, out, begin, len);
            begin += len;
        }
        return out;
    }

    public static char[] getChars(byte[] bytes) {
        Charset cs = Charset.forName("UTF-8");
        ByteBuffer bb = ByteBuffer.allocate(bytes.length);
        bb.put(bytes);
        bb.flip();
        CharBuffer cb = cs.decode(bb);
        return cb.array();
    }

    public static String bytesToHexString(byte[] src) {
        StringBuffer sb = new StringBuffer("");
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                sb.append(0);
            }
            sb.append(hv);
        }
        return sb.toString();
    }

    private static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public static byte[] hexStringToBytes(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pos = i * 2;
            d[i] = (byte)(ByteUtil.charToByte(hexChars[pos]) << 4 | ByteUtil.charToByte(hexChars[pos + 1]));
        }
        return d;
    }

    public static String binaryToHexString(byte[] bytes) {
        return new String(Hex.encodeHex((byte[])bytes, (boolean)false));
    }

    public static byte[] longToBytes(long x) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(0, x);
        return buffer.array();
    }
}

