/*
 * Decompiled with CFR 0.152.
 */
package com.wangyin.aks.security.api.util;

import com.wangyin.aks.security.api.model.CertDTO;
import com.wangyin.aks.security.api.util.Base64;
import java.io.ByteArrayInputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;

public class CertUtil {
    private static boolean matchUsage(boolean[] keyUsage, int usage) {
        if (usage == 0 || keyUsage == null) {
            return true;
        }
        for (int i = 0; i < Math.min(keyUsage.length, 32); ++i) {
            if ((usage & 1 << i) == 0 || keyUsage[i]) continue;
            return false;
        }
        return true;
    }

    private static CertDTO getSigner(String password, byte[] pfxCert) throws Exception {
        Certificate cert;
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        pfxCert = Base64.decode(new String(pfxCert));
        ByteArrayInputStream stream = new ByteArrayInputStream(pfxCert);
        keyStore.load(stream, password.toCharArray());
        Enumeration<String> aliases = keyStore.aliases();
        String keyAlias = null;
        if (aliases != null) {
            while (aliases.hasMoreElements()) {
                keyAlias = aliases.nextElement();
                Certificate[] certs = keyStore.getCertificateChain(keyAlias);
                if (certs == null || certs.length == 0 || !CertUtil.matchUsage(((X509Certificate)(cert = (X509Certificate)certs[0])).getKeyUsage(), 1)) continue;
                try {
                    ((X509Certificate)cert).checkValidity();
                    break;
                }
                catch (CertificateException e) {
                }
            }
        }
        if (keyAlias == null) {
            throw new GeneralSecurityException("None certificate for sign in this keystore");
        }
        X509Certificate[] certificates = null;
        if (keyStore.isKeyEntry(keyAlias)) {
            int i;
            Certificate[] certs = keyStore.getCertificateChain(keyAlias);
            for (i = 0; i < certs.length; ++i) {
                if (certs[i] instanceof X509Certificate) continue;
                throw new GeneralSecurityException("Certificate[" + i + "] in chain '" + keyAlias + "' is not a X509Certificate.");
            }
            certificates = new X509Certificate[certs.length];
            for (i = 0; i < certs.length; ++i) {
                certificates[i] = (X509Certificate)certs[i];
            }
        } else if (keyStore.isCertificateEntry(keyAlias)) {
            cert = keyStore.getCertificate(keyAlias);
            if (cert instanceof X509Certificate) {
                certificates = new X509Certificate[]{(X509Certificate)cert};
            }
        } else {
            throw new GeneralSecurityException(keyAlias + " is unknown to this keystore");
        }
        PrivateKey privateKey = (PrivateKey)keyStore.getKey(keyAlias, password.toCharArray());
        if (privateKey == null) {
            throw new GeneralSecurityException(keyAlias + " could not be accessed");
        }
        CertDTO cert2 = new CertDTO();
        cert2.setPriKey(privateKey);
        cert2.setCert(certificates);
        return cert2;
    }

    public static CertDTO getCertInfo(String password, String cert) {
        try {
            return CertUtil.getSigner(password, cert.getBytes());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static X509Certificate getPublicCert(String cert) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X509");
            ByteArrayInputStream inStream = new ByteArrayInputStream(Base64.decode(cert));
            X509Certificate x509 = (X509Certificate)cf.generateCertificate(inStream);
            return x509;
        }
        catch (CertificateException e) {
            e.printStackTrace();
            return null;
        }
    }
}

