/*
 * Decompiled with CFR 0.152.
 */
package com.wangyin.aks.security.api.util;

import com.wangyin.aks.security.api.util.BCBase;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.xml.bind.DatatypeConverter;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;

public class EnvelopUtil
extends BCBase {
    public static String encryptEnvelop(byte[] data, String certBase64) throws Exception {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X509");
            ByteArrayInputStream inStream = new ByteArrayInputStream(DatatypeConverter.parseBase64Binary((String)certBase64));
            X509Certificate x509 = (X509Certificate)cf.generateCertificate(inStream);
            CMSProcessableByteArray dataArray = new CMSProcessableByteArray(data);
            CMSEnvelopedDataGenerator generator = new CMSEnvelopedDataGenerator();
            generator.addRecipientInfoGenerator((RecipientInfoGenerator)new JceKeyTransRecipientInfoGenerator(x509).setProvider("BC"));
            CMSEnvelopedData enveloped = generator.generate((CMSTypedData)dataArray, new JceCMSContentEncryptorBuilder(CMSAlgorithm.DES_EDE3_CBC).setProvider("BC").build());
            ContentInfo asn1Structure = enveloped.toASN1Structure();
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dOut = new DEROutputStream((OutputStream)bOut);
            dOut.writeObject((ASN1Encodable)asn1Structure);
            return DatatypeConverter.printBase64Binary((byte[])bOut.toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static byte[] decryptEnvelop(String envelopB64, String privateKey) throws Exception {
        byte[] keyBytes = DatatypeConverter.parseBase64Binary((String)privateKey);
        return EnvelopUtil.decryptEnvelop(envelopB64, keyBytes);
    }

    public static byte[] decryptEnvelop(String envelopB64, byte[] keyBytes) throws Exception {
        byte[] result = null;
        try {
            CMSEnvelopedData enveloped = new CMSEnvelopedData(DatatypeConverter.parseBase64Binary((String)envelopB64));
            RecipientInformationStore recipient = enveloped.getRecipientInfos();
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PrivateKey privateK = keyFactory.generatePrivate(pkcs8KeySpec);
            if (recipient != null) {
                for (RecipientInformation information : recipient.getRecipients()) {
                    result = information.getContent((Recipient)new JceKeyTransEnvelopedRecipient(privateK).setProvider("BC"));
                }
            }
            return result;
        }
        catch (CMSException e) {
            e.printStackTrace();
            throw e;
        }
    }
}

