/*
 * Decompiled with CFR 0.152.
 */
package com.wangyin.aks.security.api.util;

import com.wangyin.aks.security.api.util.BCBase;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.crypto.Cipher;
import javax.xml.bind.DatatypeConverter;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;

public class RSAUtil
extends BCBase {
    public static final String KEY_ALGORITHM = "RSA";
    public static final String SIGNATURE_ALGORITHM = "SHA256withRSA";
    public static final String PUBLIC_KEY = "RSAPublicKey";
    public static final String PRIVATE_KEY = "RSAPrivateKey";
    private static final int RSA_KEY_LENGTH = 2048;
    private static final int MAX_DECRYPT_BLOCK = 256;
    private static final int MAX_ENCRYPT_BLOCK = 245;

    public static Map<String, Object> genKeyPair() throws Exception {
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(KEY_ALGORITHM);
        keyPairGen.initialize(2048);
        KeyPair keyPair = keyPairGen.generateKeyPair();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        HashMap<String, Object> keyMap = new HashMap<String, Object>(2);
        keyMap.put(PUBLIC_KEY, publicKey);
        keyMap.put(PRIVATE_KEY, privateKey);
        return keyMap;
    }

    public static String sign(byte[] data, String privateKeyB64) throws Exception {
        byte[] keyBytes = DatatypeConverter.parseBase64Binary((String)privateKeyB64);
        return RSAUtil.sign(data, keyBytes);
    }

    public static String sign(byte[] data, byte[] privateKeyBytes) throws Exception {
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(privateKeyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PrivateKey privateK = keyFactory.generatePrivate(pkcs8KeySpec);
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initSign(privateK);
        signature.update(data);
        return DatatypeConverter.printBase64Binary((byte[])signature.sign());
    }

    public static String signP7(byte[] data, byte[] privateKeyBytes, String certB64, boolean isAttach) throws Exception {
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(privateKeyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PrivateKey privateK = keyFactory.generatePrivate(pkcs8KeySpec);
        CertificateFactory cf = CertificateFactory.getInstance("X509");
        ByteArrayInputStream inStream = new ByteArrayInputStream(DatatypeConverter.parseBase64Binary((String)certB64));
        X509Certificate x509 = (X509Certificate)cf.generateCertificate(inStream);
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(x509);
        CMSProcessableByteArray msg = new CMSProcessableByteArray(data);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        ContentSigner shaSigner = new JcaContentSignerBuilder(SIGNATURE_ALGORITHM).setProvider("BC").build(privateK);
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider("BC").build()).build(shaSigner, x509));
        gen.addCertificates((Store)certs);
        CMSSignedData sigData = gen.generate((CMSTypedData)msg, isAttach);
        ContentInfo asn1Structure = sigData.toASN1Structure();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DEROutputStream dOut = new DEROutputStream((OutputStream)bOut);
        dOut.writeObject((ASN1Encodable)asn1Structure);
        return DatatypeConverter.printBase64Binary((byte[])bOut.toByteArray());
    }

    public static boolean verify(byte[] data, String publicKeyB64, String sign) throws Exception {
        byte[] keyBytes = DatatypeConverter.parseBase64Binary((String)publicKeyB64);
        return RSAUtil.verify(data, keyBytes, sign);
    }

    public static boolean verify(byte[] data, byte[] publicKeyBytes, String sign) throws Exception {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicKeyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PublicKey publicK = keyFactory.generatePublic(keySpec);
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initVerify(publicK);
        signature.update(data);
        return signature.verify(DatatypeConverter.parseBase64Binary((String)sign));
    }

    public static String[] verifyP7(byte[] data, String signedData, boolean isAttach) throws Exception {
        CMSSignedData sign;
        if (isAttach) {
            sign = new CMSSignedData(DatatypeConverter.parseBase64Binary((String)signedData));
        } else {
            CMSProcessableByteArray content = new CMSProcessableByteArray(data);
            sign = new CMSSignedData((CMSProcessable)content, DatatypeConverter.parseBase64Binary((String)signedData));
        }
        Store certs = sign.getCertificates();
        SignerInformationStore signers = sign.getSignerInfos();
        Collection c = signers.getSigners();
        String[] result = new String[c.size() + 1];
        Iterator it = c.iterator();
        int size = 0;
        while (it.hasNext()) {
            SignerInformation signer = (SignerInformation)it.next();
            Collection certCollection = certs.getMatches((Selector)signer.getSID());
            Iterator certIt = certCollection.iterator();
            X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
            result[++size] = DatatypeConverter.printBase64Binary((byte[])cert.getEncoded());
            if (!signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build(cert))) continue;
            if (isAttach) {
                result[0] = DatatypeConverter.printBase64Binary((byte[])((byte[])sign.getSignedContent().getContent()));
                continue;
            }
            result[0] = "";
        }
        return result;
    }

    public static byte[] decryptByPrivateKey(byte[] encryptedData, String privateKeyB64) throws Exception {
        byte[] keyBytes = DatatypeConverter.parseBase64Binary((String)privateKeyB64);
        return RSAUtil.decryptByPrivateKey(encryptedData, keyBytes);
    }

    public static byte[] decryptByPrivateKey(byte[] encryptedData, byte[] privateKeyBytes) throws Exception {
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(privateKeyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PrivateKey privateK = keyFactory.generatePrivate(pkcs8KeySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(2, privateK);
        return RSAUtil.doCipher(cipher, encryptedData, false);
    }

    public static byte[] decryptByPublicKey(byte[] encryptedData, String publicKeyB64) throws Exception {
        byte[] keyBytes = DatatypeConverter.parseBase64Binary((String)publicKeyB64);
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PublicKey publicK = keyFactory.generatePublic(x509KeySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(2, publicK);
        return RSAUtil.doCipher(cipher, encryptedData, false);
    }

    public static String encryptByPublicKey(byte[] data, String publicKeyB64) throws Exception {
        byte[] keyBytes = DatatypeConverter.parseBase64Binary((String)publicKeyB64);
        return RSAUtil.encryptByPublicKey(data, keyBytes);
    }

    public static String encryptByPublicKey(byte[] data, byte[] publicKeyBytes) throws Exception {
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(publicKeyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PublicKey publicK = keyFactory.generatePublic(x509KeySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(1, publicK);
        byte[] encryptedData = RSAUtil.doCipher(cipher, data, true);
        return DatatypeConverter.printBase64Binary((byte[])encryptedData);
    }

    public static String encryptByPrivateKey(byte[] data, String privateKeyB64) throws Exception {
        byte[] keyBytes = DatatypeConverter.parseBase64Binary((String)privateKeyB64);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PrivateKey privateK = keyFactory.generatePrivate(pkcs8KeySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(1, privateK);
        byte[] encryptedData = RSAUtil.doCipher(cipher, data, true);
        return DatatypeConverter.printBase64Binary((byte[])encryptedData);
    }

    public static byte[] doCipher(Cipher cipher, byte[] data, boolean isEncrypt) throws Exception {
        int block = 256;
        if (isEncrypt) {
            block = 245;
        }
        int inputLen = data.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > block ? cipher.doFinal(data, offSet, block) : cipher.doFinal(data, offSet, inputLen - offSet);
            out.write(cache, 0, cache.length);
            offSet = ++i * block;
        }
        byte[] result = out.toByteArray();
        out.close();
        return result;
    }

    public static String getPrivateKey(Map<String, Object> keyMap) throws Exception {
        Key key = (Key)keyMap.get(PRIVATE_KEY);
        return DatatypeConverter.printBase64Binary((byte[])key.getEncoded());
    }

    public static String getPublicKey(Map<String, Object> keyMap) throws Exception {
        Key key = (Key)keyMap.get(PUBLIC_KEY);
        return DatatypeConverter.printBase64Binary((byte[])key.getEncoded());
    }
}

