/*
 * Decompiled with CFR 0.152.
 */
package com.wangyin.aks.security.api.util;

import com.wangyin.aks.security.api.util.BCBase;
import com.wangyin.aks.security.api.util.GMSupport;
import com.wangyin.aks.security.api.util.Sm2Util;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import javax.xml.bind.DatatypeConverter;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKeyAgreeEnvelopedRecipient;
import org.bouncycastle.cms.jcajce.JceKeyAgreeRecipientInfoGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.jce.spec.ECParameterSpec;

@Deprecated
public class SM2EnvelopUtil
extends BCBase {
    public static final KeyPair sm2KeyPair;

    public static String encryptEnvelop(byte[] data, X509Certificate x509) throws Exception {
        try {
            CMSProcessableByteArray dataArray = new CMSProcessableByteArray(data);
            CMSEnvelopedDataGenerator generator = new CMSEnvelopedDataGenerator();
            generator.addRecipientInfoGenerator((RecipientInfoGenerator)new JceKeyAgreeRecipientInfoGenerator(CMSAlgorithm.ECDH_SHA1KDF, sm2KeyPair.getPrivate(), sm2KeyPair.getPublic(), CMSAlgorithm.AES128_WRAP).addRecipient(x509).setProvider("BC"));
            CMSEnvelopedData enveloped = generator.generate((CMSTypedData)dataArray, new JceCMSContentEncryptorBuilder(GMObjectIdentifiers.sms4_cbc, 128).setProvider("BC").build());
            ContentInfo asn1Structure = enveloped.toASN1Structure();
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dOut = new DEROutputStream((OutputStream)bOut);
            dOut.writeObject((ASN1Encodable)asn1Structure);
            return DatatypeConverter.printBase64Binary((byte[])bOut.toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static byte[] decryptEnvelop(String envelopB64, PrivateKey privateKey) throws Exception {
        byte[] result = null;
        try {
            CMSEnvelopedData enveloped = new CMSEnvelopedData(DatatypeConverter.parseBase64Binary((String)envelopB64));
            RecipientInformationStore recipient = enveloped.getRecipientInfos();
            if (recipient != null) {
                for (RecipientInformation information : recipient.getRecipients()) {
                    result = information.getContent((Recipient)new JceKeyAgreeEnvelopedRecipient(privateKey).setProvider("BC"));
                }
            }
            return result;
        }
        catch (CMSException e) {
            e.printStackTrace();
            throw e;
        }
    }

    static {
        GMSupport.crack();
        try {
            ECDomainParameters domainParameters = Sm2Util.DOMAIN_PARAMS;
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("EC", "BC");
            ECParameterSpec parameterSpec = new ECParameterSpec(domainParameters.getCurve(), domainParameters.getG(), domainParameters.getN(), domainParameters.getH());
            kpg.initialize((AlgorithmParameterSpec)parameterSpec, new SecureRandom());
            sm2KeyPair = kpg.generateKeyPair();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

