/*
 * Decompiled with CFR 0.152.
 */
package com.wangyin.aks.security.api.util;

import com.wangyin.aks.security.api.model.AlgEnum;
import com.wangyin.aks.security.api.model.ModeEnum;
import com.wangyin.aks.security.api.model.PaddingEnum;
import com.wangyin.aks.security.api.util.BCBase;
import com.wangyin.aks.security.api.util.BCECUtil;
import com.wangyin.aks.security.api.util.ByteUtil;
import com.wangyin.aks.security.api.util.Sm2EncryptResult;
import com.wangyin.aks.security.api.util.Sm2Util;
import com.wangyin.aks.security.api.util.SymmetricCryptoUtil;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.xml.bind.DatatypeConverter;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.util.BigIntegers;

public class SM2EnvelopUtil2
extends BCBase {
    public static String encryptEnvelop(byte[] data, X509Certificate x509) throws Exception {
        try {
            byte[] key = new byte[16];
            byte[] iv = new byte[16];
            SecureRandom random = new SecureRandom();
            random.nextBytes(key);
            random.nextBytes(iv);
            byte[] sm2Cipher = Sm2Util.encryt(BCECUtil.convertPublicKeyToParameters((BCECPublicKey)x509.getPublicKey()), key);
            Sm2EncryptResult sm2EncryptResult = Sm2Util.parseSm2CipherText(sm2Cipher);
            BigInteger bigInteger1 = BigIntegers.fromUnsignedByteArray((byte[])ByteUtil.copy(sm2EncryptResult.getC1(), 1, 32));
            BigInteger bigInteger2 = BigIntegers.fromUnsignedByteArray((byte[])ByteUtil.copy(sm2EncryptResult.getC1(), 33, 32));
            ASN1Integer c11 = new ASN1Integer(bigInteger1);
            ASN1Integer c12 = new ASN1Integer(bigInteger2);
            DEROctetString c2 = new DEROctetString(sm2EncryptResult.getC2());
            DEROctetString c3 = new DEROctetString(sm2EncryptResult.getC3());
            ASN1EncodableVector vector = new ASN1EncodableVector();
            vector.add((ASN1Encodable)c11);
            vector.add((ASN1Encodable)c12);
            vector.add((ASN1Encodable)c3);
            vector.add((ASN1Encodable)c2);
            byte[] version = new byte[]{1};
            byte[] enkey = new DERSequence(vector).getEncoded();
            byte[] endata = SymmetricCryptoUtil.encrypt(data, key, AlgEnum.ALG_SM4, ModeEnum.MODE_CBC, PaddingEnum.PADDING_PKCS7, iv);
            byte[] result = ByteUtil.joinBytes(version, enkey, iv, endata);
            return DatatypeConverter.printBase64Binary((byte[])result);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static byte[] decryptEnvelop(String envelopB64, PrivateKey privateKey) throws Exception {
        byte[] bytes = DatatypeConverter.parseBase64Binary((String)envelopB64);
        byte version = bytes[0];
        if (version == 1) {
            int keyLength = 2 + bytes[2];
            byte[] enkey = Arrays.copyOfRange(bytes, 1, 1 + keyLength);
            byte[] iv = Arrays.copyOfRange(bytes, 1 + keyLength, 1 + keyLength + 16);
            byte[] endata = Arrays.copyOfRange(bytes, 1 + keyLength + 16, bytes.length);
            ASN1Sequence dataSequence = ASN1Sequence.getInstance((Object)enkey);
            ASN1Integer c11 = (ASN1Integer)dataSequence.getObjectAt(0);
            ASN1Integer c12 = (ASN1Integer)dataSequence.getObjectAt(1);
            DEROctetString c2 = (DEROctetString)dataSequence.getObjectAt(3);
            DEROctetString c3 = (DEROctetString)dataSequence.getObjectAt(2);
            byte[] c11b = BigIntegers.asUnsignedByteArray((int)32, (BigInteger)c11.getValue());
            byte[] c12b = BigIntegers.asUnsignedByteArray((int)32, (BigInteger)c12.getValue());
            byte[] c2b = c2.getOctets();
            byte[] c3b = c3.getOctets();
            byte[] key = Sm2Util.decrypt(BCECUtil.convertPrivateKeyToParameters((BCECPrivateKey)privateKey), ByteUtil.joinBytes({4}, c11b, c12b, c2b, c3b));
            return SymmetricCryptoUtil.decrypt(endata, key, AlgEnum.ALG_SM4, ModeEnum.MODE_CBC, PaddingEnum.PADDING_PKCS7, iv);
        }
        throw new CMSException("unknow aks envelop version " + version);
    }
}

