/*
 * Decompiled with CFR 0.152.
 */
package com.wangyin.aks.security.api.util;

import com.wangyin.aks.pdf.util.PKCS12Keystore;
import com.wangyin.aks.security.api.util.BCBase;
import com.wangyin.aks.security.api.util.BCECUtil;
import com.wangyin.aks.security.api.util.Sm2EncryptResult;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.xml.bind.DatatypeConverter;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithID;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.SM2Signer;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;

public class Sm2Util
extends BCBase {
    public static final BigInteger SM2_ECC_P = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF", 16);
    public static final BigInteger SM2_ECC_A = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC", 16);
    public static final BigInteger SM2_ECC_B = new BigInteger("28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93", 16);
    public static final BigInteger SM2_ECC_N = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123", 16);
    public static final BigInteger SM2_ECC_GX = new BigInteger("32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7", 16);
    public static final BigInteger SM2_ECC_GY = new BigInteger("BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0", 16);
    public static final ECCurve CURVE = new ECCurve.Fp(SM2_ECC_P, SM2_ECC_A, SM2_ECC_B);
    public static final ECPoint G_POINT = CURVE.createPoint(SM2_ECC_GX, SM2_ECC_GY);
    public static final ECDomainParameters DOMAIN_PARAMS = new ECDomainParameters(CURVE, G_POINT, SM2_ECC_N, BigInteger.ONE);
    public static final int SM3_DIGEST_LENGTH = 32;

    public static AsymmetricCipherKeyPair generateKeyPair() {
        SecureRandom random = new SecureRandom();
        return BCECUtil.generateKeyPair(DOMAIN_PARAMS, random);
    }

    public static byte[] encryt(ECPublicKeyParameters pubKey, byte[] srcData) throws InvalidCipherTextException {
        SM2Engine engine = new SM2Engine();
        ParametersWithRandom pwr = new ParametersWithRandom((CipherParameters)pubKey, new SecureRandom(srcData));
        engine.init(true, (CipherParameters)pwr);
        return engine.processBlock(srcData, 0, srcData.length);
    }

    public static byte[] decrypt(ECPrivateKeyParameters priKey, byte[] sm2CipherText) throws InvalidCipherTextException {
        SM2Engine engine = new SM2Engine();
        engine.init(false, (CipherParameters)priKey);
        return engine.processBlock(sm2CipherText, 0, sm2CipherText.length);
    }

    public static Sm2EncryptResult parseSm2CipherText(byte[] cipherText) {
        int curveLength = BCECUtil.getCurveLength(DOMAIN_PARAMS);
        return Sm2Util.parseSm2CipherText(curveLength, 32, cipherText);
    }

    public static Sm2EncryptResult parseSm2CipherText(int curveLength, int digestLength, byte[] cipherText) {
        byte[] c1 = new byte[curveLength * 2 + 1];
        System.arraycopy(cipherText, 0, c1, 0, c1.length);
        byte[] c2 = new byte[cipherText.length - c1.length - digestLength];
        System.arraycopy(cipherText, c1.length, c2, 0, c2.length);
        byte[] c3 = new byte[digestLength];
        System.arraycopy(cipherText, c1.length + c2.length, c3, 0, c3.length);
        Sm2EncryptResult result = new Sm2EncryptResult();
        result.setC1(c1);
        result.setC2(c2);
        result.setC3(c3);
        result.setCipherText(cipherText);
        return result;
    }

    public static byte[] sign(ECPrivateKeyParameters priKey, byte[] srcData) throws NoSuchAlgorithmException, NoSuchProviderException, CryptoException {
        return Sm2Util.sign(priKey, null, srcData);
    }

    public static byte[] sign(ECPrivateKeyParameters priKey, byte[] withId, byte[] srcData) throws NoSuchAlgorithmException, NoSuchProviderException, CryptoException {
        SM2Signer signer = new SM2Signer();
        Object param = null;
        ParametersWithRandom pwr = new ParametersWithRandom((CipherParameters)priKey, new SecureRandom());
        param = withId != null ? new ParametersWithID((CipherParameters)pwr, withId) : pwr;
        signer.init(true, (CipherParameters)param);
        signer.update(srcData, 0, srcData.length);
        return signer.generateSignature();
    }

    public static boolean verify(ECPublicKeyParameters pubKey, byte[] srcData, byte[] sign) {
        return Sm2Util.verify(pubKey, null, srcData, sign);
    }

    public static boolean verify(ECPublicKeyParameters pubKey, byte[] withId, byte[] srcData, byte[] sign) {
        SM2Signer signer = new SM2Signer();
        Object param = null;
        param = withId != null ? new ParametersWithID((CipherParameters)pubKey, withId) : pubKey;
        signer.init(false, (CipherParameters)param);
        signer.update(srcData, 0, srcData.length);
        return signer.verifySignature(sign);
    }

    public static String signP7(byte[] data, byte[] pfx, String password, boolean isAttach) throws Exception {
        PKCS12Keystore keystore = PKCS12Keystore.getInstance(pfx, password);
        CMSProcessableByteArray msg = new CMSProcessableByteArray(data);
        JcaCertStore certs = new JcaCertStore(Collections.singletonList(keystore.getCert()));
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        ContentSigner shaSigner = new JcaContentSignerBuilder("SM3WITHSM2").setProvider("BC").build(keystore.getPrivateKey());
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider("BC").build()).setDirectSignature(true).build(shaSigner, keystore.getCert()));
        gen.addCertificates((Store)certs);
        CMSSignedData sigData = gen.generate((CMSTypedData)msg, isAttach);
        ContentInfo asn1Structure = sigData.toASN1Structure();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DEROutputStream dOut = new DEROutputStream((OutputStream)bOut);
        dOut.writeObject((ASN1Encodable)asn1Structure);
        return DatatypeConverter.printBase64Binary((byte[])bOut.toByteArray());
    }

    public static String[] verifyP7(byte[] data, String signedData, boolean isAttach) throws Exception {
        CMSSignedData sign;
        if (isAttach) {
            sign = new CMSSignedData(DatatypeConverter.parseBase64Binary((String)signedData));
        } else {
            CMSProcessableByteArray content = new CMSProcessableByteArray(data);
            sign = new CMSSignedData((CMSProcessable)content, DatatypeConverter.parseBase64Binary((String)signedData));
        }
        Store certs = sign.getCertificates();
        SignerInformationStore signers = sign.getSignerInfos();
        Collection c = signers.getSigners();
        String[] result = new String[c.size() + 1];
        Iterator it = c.iterator();
        int size = 0;
        while (it.hasNext()) {
            SignerInformation signer = (SignerInformation)it.next();
            Collection certCollection = certs.getMatches((Selector)signer.getSID());
            Iterator certIt = certCollection.iterator();
            X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
            result[++size] = DatatypeConverter.printBase64Binary((byte[])cert.getEncoded());
            if (!signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build(cert))) continue;
            if (isAttach) {
                result[0] = DatatypeConverter.printBase64Binary((byte[])((byte[])sign.getSignedContent().getContent()));
                continue;
            }
            result[0] = "";
        }
        return result;
    }
}

