/*
 * Decompiled with CFR 0.152.
 */
package com.wangyin.aks.security.api.util;

import com.wangyin.aks.security.api.model.AlgEnum;
import com.wangyin.aks.security.api.model.ModeEnum;
import com.wangyin.aks.security.api.model.PaddingEnum;
import com.wangyin.aks.security.api.util.BCBase;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;

public class SymmetricCryptoUtil
extends BCBase {
    public static String encryptString(byte[] data, byte[] key) throws Exception {
        return DatatypeConverter.printBase64Binary((byte[])SymmetricCryptoUtil.encrypt(data, key));
    }

    public static byte[] encrypt(byte[] data, byte[] key) throws Exception {
        return SymmetricCryptoUtil.encrypt(data, key, AlgEnum.ALG_AES, ModeEnum.MODE_ECB, PaddingEnum.PADDING_PKCS7, null);
    }

    public static byte[] decrypt(byte[] data, byte[] key) throws Exception {
        return SymmetricCryptoUtil.decrypt(data, key, AlgEnum.ALG_AES, ModeEnum.MODE_ECB, PaddingEnum.PADDING_PKCS7, null);
    }

    public static byte[] encrypt(byte[] data, byte[] key, AlgEnum algEnum, ModeEnum modeEnum, PaddingEnum paddingEnum, byte[] iv) throws Exception {
        Key k = SymmetricCryptoUtil.toKey(algEnum, key);
        String algString = SymmetricCryptoUtil.getAlgorithmString(algEnum, modeEnum, paddingEnum);
        Cipher cipher = Cipher.getInstance(algString, "BC");
        if (ModeEnum.MODE_CBC.equals((Object)modeEnum)) {
            IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
            cipher.init(1, k, ivParameterSpec);
        } else {
            cipher.init(1, k);
        }
        return cipher.doFinal(data);
    }

    public static byte[] decrypt(byte[] data, byte[] key, AlgEnum algEnum, ModeEnum modeEnum, PaddingEnum paddingEnum, byte[] iv) throws Exception {
        Key k = SymmetricCryptoUtil.toKey(algEnum, key);
        String algString = SymmetricCryptoUtil.getAlgorithmString(algEnum, modeEnum, paddingEnum);
        Cipher cipher = Cipher.getInstance(algString, "BC");
        if (ModeEnum.MODE_CBC.equals((Object)modeEnum)) {
            IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
            cipher.init(2, k, ivParameterSpec);
        } else {
            cipher.init(2, k);
        }
        return cipher.doFinal(data);
    }

    public static byte[] generateKey(AlgEnum algEnum, int keyLength) throws NoSuchAlgorithmException {
        KeyGenerator kg = KeyGenerator.getInstance(algEnum.getAlg());
        kg.init(keyLength, new SecureRandom());
        SecretKey sk = kg.generateKey();
        return sk.getEncoded();
    }

    private static Key toKey(AlgEnum algEnum, byte[] key) throws Exception {
        return new SecretKeySpec(key, algEnum.getAlg());
    }

    private static String getAlgorithmString(AlgEnum algEnum, ModeEnum modeEnum, PaddingEnum paddingEnum) {
        if (algEnum == null) {
            algEnum = AlgEnum.ALG_SM4;
        }
        if (modeEnum == null) {
            modeEnum = ModeEnum.MODE_CBC;
        }
        if (paddingEnum == null) {
            paddingEnum = PaddingEnum.PADDING_PKCS7;
        }
        return algEnum.getAlg() + "/" + modeEnum.getAlg() + "/" + paddingEnum.getAlg();
    }
}

