/*
 * Decompiled with CFR 0.152.
 */
package com.jdkhome.blzo.ex.redission.actuator;

import com.jdkhome.blzo.ex.basic.configuration.ApplicationContextProvider;
import com.jdkhome.blzo.ex.basic.enums.BasicResponseError;
import com.jdkhome.blzo.ex.basic.exception.ServiceException;
import com.jdkhome.blzo.ex.basic.pojo.BaseError;
import com.jdkhome.blzo.ex.redission.Consumer;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FairLockActuator {
    private static final Logger log = LoggerFactory.getLogger(FairLockActuator.class);
    private String key;
    private long wait = 2L;
    private long lease = 10L;

    public void exec(Consumer action) {
        RedissonClient redissonClient = (RedissonClient)ApplicationContextProvider.getBean(RedissonClient.class);
        RLock fairLock = redissonClient.getFairLock(this.key);
        try {
            boolean lockResult = fairLock.tryLock(this.wait, this.lease, TimeUnit.SECONDS);
            if (!lockResult) {
                log.warn("\u83b7\u53d6\u5206\u5e03\u5f0f\u516c\u5e73\u9501\u5931\u8d25 \u8d85\u65f6 : {} ", (Object)fairLock);
                throw new ServiceException((BaseError)BasicResponseError.SERVER_BUSY);
            }
            log.debug("\u6210\u529f\u83b7\u53d6\u5206\u5e03\u5f0f\u516c\u5e73\u9501 : {} ", (Object)fairLock);
            action.accept();
        }
        catch (ServiceException se) {
            log.warn("\u4e1a\u52a1\u5f02\u5e38 \u5f53\u524d\u5360\u7528\u5206\u5e03\u5f0f\u516c\u5e73\u9501 : {} exception :{}  ", (Object)fairLock, (Object)se.getErrorMsg());
            throw se;
        }
        catch (InterruptedException e) {
            log.warn("InterruptedException \u5f53\u524d\u5360\u7528\u5206\u5e03\u5f0f\u516c\u5e73\u9501 : {} ", (Object)fairLock);
            Thread.currentThread().interrupt();
            throw new ServiceException((BaseError)BasicResponseError.SERVER_ERROR, (Object)e);
        }
        catch (Exception e) {
            log.warn("\u5176\u4ed6\u5f02\u5e38 \u5f53\u524d\u5360\u7528\u5206\u5e03\u5f0f\u516c\u5e73\u9501 : {} exception :{}  ", (Object)fairLock, (Object)e.getMessage());
            throw e;
        }
        finally {
            if (null != fairLock) {
                try {
                    fairLock.unlock();
                    log.debug("\u6210\u529f\u91ca\u653e\u5206\u5e03\u5f0f\u516c\u5e73\u9501 : {} ", (Object)fairLock);
                }
                catch (Exception e) {
                    log.warn("\u91ca\u653e\u5206\u5e03\u5f0f\u9501\u5931\u516c\u5e73\u9501", (Throwable)e);
                }
            }
        }
    }

    public FairLockActuator(String key, long wait, long lease) {
        this.key = key;
        this.wait = wait;
        this.lease = lease;
    }

    public FairLockActuator(String key) {
        this.key = key;
    }

    public static FairLockActuator create(String key, long wait, long lease) {
        return new FairLockActuator(key, wait, lease);
    }

    public static FairLockActuator create(String key) {
        return new FairLockActuator(key);
    }
}

