/*
 * Decompiled with CFR 0.152.
 */
package com.jdkhome.blzo.ex.redission.actuator;

import com.jdkhome.blzo.ex.basic.configuration.ApplicationContextProvider;
import com.jdkhome.blzo.ex.basic.enums.BasicResponseError;
import com.jdkhome.blzo.ex.basic.exception.ServiceException;
import com.jdkhome.blzo.ex.basic.pojo.BaseError;
import com.jdkhome.blzo.ex.redission.Consumer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.redisson.RedissonMultiLock;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiLockActuator {
    private static final Logger log = LoggerFactory.getLogger(MultiLockActuator.class);
    private List<String> keys;
    private long wait = 2L;
    private long lease = 10L;

    public void exec(Consumer action) {
        RedissonClient redissonClient = (RedissonClient)ApplicationContextProvider.getBean(RedissonClient.class);
        ArrayList rLockList = new ArrayList();
        this.keys.forEach(key -> rLockList.add(redissonClient.getLock(key)));
        RedissonMultiLock multiLock = new RedissonMultiLock(rLockList.toArray(new RLock[0]));
        try {
            boolean lockResult = multiLock.tryLock(this.wait, this.lease, TimeUnit.SECONDS);
            if (!lockResult) {
                log.warn("\u83b7\u53d6\u5206\u5e03\u5f0f\u8054\u9501\u5931\u8d25 \u8d85\u65f6 : {} ", (Object)multiLock);
                throw new ServiceException((BaseError)BasicResponseError.SERVER_BUSY);
            }
            log.debug("\u6210\u529f\u83b7\u53d6\u5206\u5e03\u5f0f\u8054\u9501 : {} ", (Object)multiLock);
            action.accept();
        }
        catch (ServiceException se) {
            log.warn("\u4e1a\u52a1\u5f02\u5e38 \u5f53\u524d\u5360\u7528\u5206\u5e03\u5f0f\u9501 : {} exception :{}  ", (Object)multiLock, (Object)se.getErrorMsg());
            throw se;
        }
        catch (InterruptedException e) {
            log.warn("InterruptedException \u5f53\u524d\u5360\u7528\u5206\u5e03\u5f0f\u9501 : {} ", (Object)multiLock);
            Thread.currentThread().interrupt();
            throw new ServiceException((BaseError)BasicResponseError.SERVER_ERROR, (Object)e);
        }
        catch (Exception e) {
            log.warn("\u5176\u4ed6\u5f02\u5e38 \u5f53\u524d\u5360\u7528\u5206\u5e03\u5f0f\u9501 : {} exception :{}  ", (Object)multiLock, (Object)e.getMessage());
            throw e;
        }
        finally {
            if (null != multiLock) {
                try {
                    multiLock.unlock();
                    log.debug("\u6210\u529f\u91ca\u653e\u5206\u5e03\u5f0f\u9501 : {} ", (Object)multiLock);
                }
                catch (Exception e) {
                    log.warn("\u91ca\u653e\u5206\u5e03\u5f0f\u9501\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    public MultiLockActuator(List<String> keys, long wait, long lease) {
        this.keys = keys;
        this.wait = wait;
        this.lease = lease;
    }

    public MultiLockActuator(List<String> keys) {
        this.keys = keys;
    }

    public static MultiLockActuator create(List<String> keys, long wait, long lease) {
        return new MultiLockActuator(keys, wait, lease);
    }

    public static MultiLockActuator create(List<String> keys) {
        return new MultiLockActuator(keys);
    }
}

