/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.weixin.sdk.api;

import com.jfinal.weixin.sdk.api.ReturnCode;
import com.jfinal.weixin.sdk.utils.JsonUtils;
import com.jfinal.weixin.sdk.utils.RetryUtils;
import java.io.Serializable;
import java.util.Map;

public class AccessToken
implements RetryUtils.ResultCheck,
Serializable {
    private static final long serialVersionUID = -822464425433824314L;
    private String access_token;
    private Integer expires_in;
    private Integer errcode;
    private String errmsg;
    private Long expiredTime;
    private String json;

    public AccessToken(String jsonStr) {
        this.json = jsonStr;
        try {
            Map temp = JsonUtils.parse(jsonStr, Map.class);
            this.access_token = (String)temp.get("access_token");
            this.expires_in = this.getInt(temp, "expires_in");
            this.errcode = this.getInt(temp, "errcode");
            this.errmsg = (String)temp.get("errmsg");
            if (this.expires_in != null) {
                this.expiredTime = System.currentTimeMillis() + (long)((this.expires_in - 5) * 1000);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getJson() {
        return this.json;
    }

    public boolean isAvailable() {
        if (this.expiredTime == null) {
            return false;
        }
        if (this.errcode != null) {
            return false;
        }
        if (this.expiredTime < System.currentTimeMillis()) {
            return false;
        }
        return this.access_token != null;
    }

    private Integer getInt(Map<String, Object> temp, String key) {
        Number number = (Number)temp.get(key);
        return number == null ? null : Integer.valueOf(number.intValue());
    }

    public String getAccessToken() {
        return this.access_token;
    }

    public Integer getExpiresIn() {
        return this.expires_in;
    }

    public Long getExpiredTime() {
        return this.expiredTime;
    }

    public Integer getErrorCode() {
        return this.errcode;
    }

    public String getErrorMsg() {
        String result;
        if (this.errcode != null && (result = ReturnCode.get(this.errcode)) != null) {
            return result;
        }
        return this.errmsg;
    }

    @Override
    public boolean matching() {
        return this.isAvailable();
    }
}

