/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs.impl;

import com.microsoft.azure.eventhubs.impl.DispatchHandler;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.Pipe;
import java.nio.channels.SelectableChannel;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.RejectedExecutionException;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Handler;
import org.apache.qpid.proton.reactor.Reactor;
import org.apache.qpid.proton.reactor.Selectable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReactorDispatcher {
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(ReactorDispatcher.class);
    private final Reactor reactor;
    private final Pipe ioSignal;
    private final ConcurrentLinkedQueue<BaseHandler> workQueue;
    private final ScheduleHandler workScheduler;

    public ReactorDispatcher(Reactor reactor) throws IOException {
        this.reactor = reactor;
        this.ioSignal = Pipe.open();
        this.workQueue = new ConcurrentLinkedQueue();
        this.workScheduler = new ScheduleHandler();
        this.initializeSelectable();
    }

    private void initializeSelectable() {
        Selectable schedulerSelectable = this.reactor.selectable();
        schedulerSelectable.setChannel((SelectableChannel)this.ioSignal.source());
        schedulerSelectable.onReadable((Selectable.Callback)this.workScheduler);
        schedulerSelectable.onFree((Selectable.Callback)new CloseHandler());
        schedulerSelectable.setReading(true);
        this.reactor.update(schedulerSelectable);
    }

    public void invoke(DispatchHandler timerCallback) throws IOException, RejectedExecutionException {
        this.throwIfSchedulerError();
        this.workQueue.offer(timerCallback);
        this.signalWorkQueue();
    }

    public void invoke(int delay, DispatchHandler timerCallback) throws IOException, RejectedExecutionException {
        this.throwIfSchedulerError();
        this.workQueue.offer(new DelayHandler(this.reactor, delay, timerCallback));
        this.signalWorkQueue();
    }

    private void throwIfSchedulerError() {
        RejectedExecutionException rejectedException = (RejectedExecutionException)this.reactor.attachments().get(RejectedExecutionException.class, RejectedExecutionException.class);
        if (rejectedException != null) {
            throw new RejectedExecutionException(rejectedException.getMessage(), rejectedException);
        }
        if (!this.ioSignal.sink().isOpen()) {
            throw new RejectedExecutionException("ReactorDispatcher instance is closed.");
        }
    }

    private void signalWorkQueue() throws IOException {
        try {
            while (this.ioSignal.sink().write(ByteBuffer.allocate(1)) == 0) {
            }
        }
        catch (ClosedChannelException ignorePipeClosedDuringReactorShutdown) {
            TRACE_LOGGER.info("signalWorkQueue failed with an error", (Throwable)ignorePipeClosedDuringReactorShutdown);
        }
    }

    private final class CloseHandler
    implements Selectable.Callback {
        private CloseHandler() {
        }

        public void run(Selectable selectable) {
            try {
                if (ReactorDispatcher.this.ioSignal.sink().isOpen()) {
                    ReactorDispatcher.this.ioSignal.sink().close();
                }
            }
            catch (IOException ioException) {
                TRACE_LOGGER.info("CloseHandler.run() sink().close() failed with an error", (Throwable)ioException);
            }
            ReactorDispatcher.this.workScheduler.run(null);
            try {
                if (ReactorDispatcher.this.ioSignal.source().isOpen()) {
                    ReactorDispatcher.this.ioSignal.source().close();
                }
            }
            catch (IOException ioException) {
                TRACE_LOGGER.info("CloseHandler.run() source().close() failed with an error", (Throwable)ioException);
            }
        }
    }

    private final class ScheduleHandler
    implements Selectable.Callback {
        private ScheduleHandler() {
        }

        public void run(Selectable selectable) {
            BaseHandler topWork;
            try {
                while (ReactorDispatcher.this.ioSignal.source().read(ByteBuffer.allocate(1024)) > 0) {
                }
            }
            catch (ClosedChannelException ignorePipeClosedDuringReactorShutdown) {
                TRACE_LOGGER.info("ScheduleHandler.run() failed with an error", (Throwable)ignorePipeClosedDuringReactorShutdown);
            }
            catch (IOException ioException) {
                TRACE_LOGGER.warn("ScheduleHandler.run() failed with an error", (Throwable)ioException);
                throw new RuntimeException(ioException);
            }
            while ((topWork = (BaseHandler)ReactorDispatcher.this.workQueue.poll()) != null) {
                topWork.onTimerTask(null);
            }
        }
    }

    private final class DelayHandler
    extends BaseHandler {
        final int delay;
        final BaseHandler timerCallback;
        final Reactor reactor;

        public DelayHandler(Reactor reactor, int delay, DispatchHandler timerCallback) {
            this.delay = delay;
            this.timerCallback = timerCallback;
            this.reactor = reactor;
        }

        public void onTimerTask(Event e) {
            this.reactor.schedule(this.delay, (Handler)this.timerCallback);
        }
    }
}

