/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs.impl;

import com.microsoft.azure.eventhubs.impl.StringUtil;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.time.Instant;
import java.util.Base64;
import java.util.Locale;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class SharedAccessSignatureTokenProvider {
    final String keyName;
    final String sharedAccessKey;
    final String sharedAccessSignature;

    SharedAccessSignatureTokenProvider(String keyName, String sharedAccessKey) {
        this.keyName = keyName;
        this.sharedAccessKey = sharedAccessKey;
        this.sharedAccessSignature = null;
    }

    public SharedAccessSignatureTokenProvider(String sharedAccessSignature) {
        this.keyName = null;
        this.sharedAccessKey = null;
        this.sharedAccessSignature = sharedAccessSignature;
    }

    public static String generateSharedAccessSignature(String keyName, String sharedAccessKey, String resource, Duration tokenTimeToLive) throws IOException, NoSuchAlgorithmException, InvalidKeyException {
        if (StringUtil.isNullOrWhiteSpace(keyName)) {
            throw new IllegalArgumentException("keyName cannot be empty");
        }
        if (StringUtil.isNullOrWhiteSpace(sharedAccessKey)) {
            throw new IllegalArgumentException("sharedAccessKey cannot be empty");
        }
        if (StringUtil.isNullOrWhiteSpace(resource)) {
            throw new IllegalArgumentException("resource cannot be empty");
        }
        if (tokenTimeToLive.isZero() || tokenTimeToLive.isNegative()) {
            throw new IllegalArgumentException("tokenTimeToLive has to positive and in the order-of seconds");
        }
        String utf8Encoding = StandardCharsets.UTF_8.name();
        String expiresOn = Long.toString(Instant.now().getEpochSecond() + tokenTimeToLive.getSeconds());
        String audienceUri = URLEncoder.encode(resource, utf8Encoding);
        String secretToSign = audienceUri + "\n" + expiresOn;
        String hashAlgorithm = "HMACSHA256";
        Mac hmac = Mac.getInstance("HMACSHA256");
        byte[] sasKeyBytes = sharedAccessKey.getBytes(utf8Encoding);
        SecretKeySpec finalKey = new SecretKeySpec(sasKeyBytes, "HMACSHA256");
        hmac.init(finalKey);
        byte[] signatureBytes = hmac.doFinal(secretToSign.getBytes(utf8Encoding));
        String signature = Base64.getEncoder().encodeToString(signatureBytes);
        return String.format(Locale.US, "SharedAccessSignature sr=%s&sig=%s&se=%s&skn=%s", audienceUri, URLEncoder.encode(signature, utf8Encoding), URLEncoder.encode(expiresOn, utf8Encoding), URLEncoder.encode(keyName, utf8Encoding));
    }

    public String getToken(String resource, Duration tokenTimeToLive) throws IOException, InvalidKeyException, NoSuchAlgorithmException {
        return this.sharedAccessSignature == null ? SharedAccessSignatureTokenProvider.generateSharedAccessSignature(this.keyName, this.sharedAccessKey, resource, tokenTimeToLive) : this.sharedAccessSignature;
    }
}

