/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.cosmosdb.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.cosmosdb.DatabaseAccountPatchParameters;
import com.microsoft.azure.management.cosmosdb.DatabaseAccountRegenerateKeyParameters;
import com.microsoft.azure.management.cosmosdb.FailoverPolicies;
import com.microsoft.azure.management.cosmosdb.KeyKind;
import com.microsoft.azure.management.cosmosdb.implementation.DatabaseAccountCreateUpdateParametersInner;
import com.microsoft.azure.management.cosmosdb.implementation.DatabaseAccountInner;
import com.microsoft.azure.management.cosmosdb.implementation.DatabaseAccountListConnectionStringsResult;
import com.microsoft.azure.management.cosmosdb.implementation.DatabaseAccountListKeysResult;
import com.microsoft.azure.management.cosmosdb.implementation.DatabaseAccountListReadOnlyKeysResultInner;
import com.microsoft.azure.management.cosmosdb.implementation.DocumentDBImpl;
import com.microsoft.azure.management.cosmosdb.implementation.FailoverPolicyInner;
import com.microsoft.azure.management.cosmosdb.implementation.PageImpl;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HEAD;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class DatabaseAccountsInner
implements InnerSupportsGet<DatabaseAccountInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<DatabaseAccountInner> {
    private DatabaseAccountsService service;
    private DocumentDBImpl client;

    public DatabaseAccountsInner(Retrofit retrofit, DocumentDBImpl client) {
        this.service = (DatabaseAccountsService)retrofit.create(DatabaseAccountsService.class);
        this.client = client;
    }

    public DatabaseAccountInner getByResourceGroup(String resourceGroupName, String accountName) {
        return (DatabaseAccountInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body());
    }

    public ServiceFuture<DatabaseAccountInner> getByResourceGroupAsync(String resourceGroupName, String accountName, ServiceCallback<DatabaseAccountInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<DatabaseAccountInner> getByResourceGroupAsync(String resourceGroupName, String accountName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<DatabaseAccountInner>, DatabaseAccountInner>(){

            public DatabaseAccountInner call(ServiceResponse<DatabaseAccountInner> response) {
                return (DatabaseAccountInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DatabaseAccountInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getByResourceGroup(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseAccountInner>>>(){

            public Observable<ServiceResponse<DatabaseAccountInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DatabaseAccountInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DatabaseAccountInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DatabaseAccountInner patch(String resourceGroupName, String accountName, Map<String, String> tags) {
        return (DatabaseAccountInner)((Object)((ServiceResponse)this.patchWithServiceResponseAsync(resourceGroupName, accountName, tags).toBlocking().last()).body());
    }

    public ServiceFuture<DatabaseAccountInner> patchAsync(String resourceGroupName, String accountName, Map<String, String> tags, ServiceCallback<DatabaseAccountInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.patchWithServiceResponseAsync(resourceGroupName, accountName, tags), serviceCallback);
    }

    public Observable<DatabaseAccountInner> patchAsync(String resourceGroupName, String accountName, Map<String, String> tags) {
        return this.patchWithServiceResponseAsync(resourceGroupName, accountName, tags).map((Func1)new Func1<ServiceResponse<DatabaseAccountInner>, DatabaseAccountInner>(){

            public DatabaseAccountInner call(ServiceResponse<DatabaseAccountInner> response) {
                return (DatabaseAccountInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DatabaseAccountInner>> patchWithServiceResponseAsync(String resourceGroupName, String accountName, Map<String, String> tags) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (tags == null) {
            throw new IllegalArgumentException("Parameter tags is required and cannot be null.");
        }
        Validator.validate(tags);
        DatabaseAccountPatchParameters updateParameters = new DatabaseAccountPatchParameters();
        updateParameters.withTags(tags);
        Observable<Response<ResponseBody>> observable = this.service.patch(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), updateParameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<DatabaseAccountInner>(){}.getType());
    }

    public DatabaseAccountInner beginPatch(String resourceGroupName, String accountName, Map<String, String> tags) {
        return (DatabaseAccountInner)((Object)((ServiceResponse)this.beginPatchWithServiceResponseAsync(resourceGroupName, accountName, tags).toBlocking().single()).body());
    }

    public ServiceFuture<DatabaseAccountInner> beginPatchAsync(String resourceGroupName, String accountName, Map<String, String> tags, ServiceCallback<DatabaseAccountInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginPatchWithServiceResponseAsync(resourceGroupName, accountName, tags), serviceCallback);
    }

    public Observable<DatabaseAccountInner> beginPatchAsync(String resourceGroupName, String accountName, Map<String, String> tags) {
        return this.beginPatchWithServiceResponseAsync(resourceGroupName, accountName, tags).map((Func1)new Func1<ServiceResponse<DatabaseAccountInner>, DatabaseAccountInner>(){

            public DatabaseAccountInner call(ServiceResponse<DatabaseAccountInner> response) {
                return (DatabaseAccountInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DatabaseAccountInner>> beginPatchWithServiceResponseAsync(String resourceGroupName, String accountName, Map<String, String> tags) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (tags == null) {
            throw new IllegalArgumentException("Parameter tags is required and cannot be null.");
        }
        Validator.validate(tags);
        DatabaseAccountPatchParameters updateParameters = new DatabaseAccountPatchParameters();
        updateParameters.withTags(tags);
        return this.service.beginPatch(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), updateParameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseAccountInner>>>(){

            public Observable<ServiceResponse<DatabaseAccountInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginPatchDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DatabaseAccountInner> beginPatchDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DatabaseAccountInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DatabaseAccountInner createOrUpdate(String resourceGroupName, String accountName, DatabaseAccountCreateUpdateParametersInner createUpdateParameters) {
        return (DatabaseAccountInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, accountName, createUpdateParameters).toBlocking().last()).body());
    }

    public ServiceFuture<DatabaseAccountInner> createOrUpdateAsync(String resourceGroupName, String accountName, DatabaseAccountCreateUpdateParametersInner createUpdateParameters, ServiceCallback<DatabaseAccountInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, accountName, createUpdateParameters), serviceCallback);
    }

    public Observable<DatabaseAccountInner> createOrUpdateAsync(String resourceGroupName, String accountName, DatabaseAccountCreateUpdateParametersInner createUpdateParameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, accountName, createUpdateParameters).map((Func1)new Func1<ServiceResponse<DatabaseAccountInner>, DatabaseAccountInner>(){

            public DatabaseAccountInner call(ServiceResponse<DatabaseAccountInner> response) {
                return (DatabaseAccountInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DatabaseAccountInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String accountName, DatabaseAccountCreateUpdateParametersInner createUpdateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)createUpdateParameters));
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), createUpdateParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<DatabaseAccountInner>(){}.getType());
    }

    public DatabaseAccountInner beginCreateOrUpdate(String resourceGroupName, String accountName, DatabaseAccountCreateUpdateParametersInner createUpdateParameters) {
        return (DatabaseAccountInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, accountName, createUpdateParameters).toBlocking().single()).body());
    }

    public ServiceFuture<DatabaseAccountInner> beginCreateOrUpdateAsync(String resourceGroupName, String accountName, DatabaseAccountCreateUpdateParametersInner createUpdateParameters, ServiceCallback<DatabaseAccountInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, accountName, createUpdateParameters), serviceCallback);
    }

    public Observable<DatabaseAccountInner> beginCreateOrUpdateAsync(String resourceGroupName, String accountName, DatabaseAccountCreateUpdateParametersInner createUpdateParameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, accountName, createUpdateParameters).map((Func1)new Func1<ServiceResponse<DatabaseAccountInner>, DatabaseAccountInner>(){

            public DatabaseAccountInner call(ServiceResponse<DatabaseAccountInner> response) {
                return (DatabaseAccountInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DatabaseAccountInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String accountName, DatabaseAccountCreateUpdateParametersInner createUpdateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)createUpdateParameters));
        return this.service.beginCreateOrUpdate(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), createUpdateParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseAccountInner>>>(){

            public Observable<ServiceResponse<DatabaseAccountInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DatabaseAccountInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DatabaseAccountInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String accountName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String accountName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String accountName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.delete(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String accountName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String accountName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String accountName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDelete(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void failoverPriorityChange(String resourceGroupName, String accountName) {
        ((ServiceResponse)this.failoverPriorityChangeWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> failoverPriorityChangeAsync(String resourceGroupName, String accountName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.failoverPriorityChangeWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<Void> failoverPriorityChangeAsync(String resourceGroupName, String accountName) {
        return this.failoverPriorityChangeWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> failoverPriorityChangeWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object failoverPoliciesConverted = null;
        FailoverPolicies failoverParameters = new FailoverPolicies();
        failoverParameters.withFailoverPolicies(null);
        Observable<Response<ResponseBody>> observable = this.service.failoverPriorityChange(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), failoverParameters, this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void failoverPriorityChange(String resourceGroupName, String accountName, List<FailoverPolicyInner> failoverPolicies) {
        ((ServiceResponse)this.failoverPriorityChangeWithServiceResponseAsync(resourceGroupName, accountName, failoverPolicies).toBlocking().last()).body();
    }

    public ServiceFuture<Void> failoverPriorityChangeAsync(String resourceGroupName, String accountName, List<FailoverPolicyInner> failoverPolicies, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.failoverPriorityChangeWithServiceResponseAsync(resourceGroupName, accountName, failoverPolicies), serviceCallback);
    }

    public Observable<Void> failoverPriorityChangeAsync(String resourceGroupName, String accountName, List<FailoverPolicyInner> failoverPolicies) {
        return this.failoverPriorityChangeWithServiceResponseAsync(resourceGroupName, accountName, failoverPolicies).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> failoverPriorityChangeWithServiceResponseAsync(String resourceGroupName, String accountName, List<FailoverPolicyInner> failoverPolicies) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(failoverPolicies);
        FailoverPolicies failoverParameters = new FailoverPolicies();
        failoverParameters.withFailoverPolicies(failoverPolicies);
        Observable<Response<ResponseBody>> observable = this.service.failoverPriorityChange(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), failoverParameters, this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginFailoverPriorityChange(String resourceGroupName, String accountName) {
        ((ServiceResponse)this.beginFailoverPriorityChangeWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginFailoverPriorityChangeAsync(String resourceGroupName, String accountName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginFailoverPriorityChangeWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<Void> beginFailoverPriorityChangeAsync(String resourceGroupName, String accountName) {
        return this.beginFailoverPriorityChangeWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginFailoverPriorityChangeWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object failoverPolicies = null;
        FailoverPolicies failoverParameters = new FailoverPolicies();
        failoverParameters.withFailoverPolicies(null);
        return this.service.beginFailoverPriorityChange(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), failoverParameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginFailoverPriorityChangeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public void beginFailoverPriorityChange(String resourceGroupName, String accountName, List<FailoverPolicyInner> failoverPolicies) {
        ((ServiceResponse)this.beginFailoverPriorityChangeWithServiceResponseAsync(resourceGroupName, accountName, failoverPolicies).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginFailoverPriorityChangeAsync(String resourceGroupName, String accountName, List<FailoverPolicyInner> failoverPolicies, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginFailoverPriorityChangeWithServiceResponseAsync(resourceGroupName, accountName, failoverPolicies), serviceCallback);
    }

    public Observable<Void> beginFailoverPriorityChangeAsync(String resourceGroupName, String accountName, List<FailoverPolicyInner> failoverPolicies) {
        return this.beginFailoverPriorityChangeWithServiceResponseAsync(resourceGroupName, accountName, failoverPolicies).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginFailoverPriorityChangeWithServiceResponseAsync(String resourceGroupName, String accountName, List<FailoverPolicyInner> failoverPolicies) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(failoverPolicies);
        FailoverPolicies failoverParameters = new FailoverPolicies();
        failoverParameters.withFailoverPolicies(failoverPolicies);
        return this.service.beginFailoverPriorityChange(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), failoverParameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginFailoverPriorityChangeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginFailoverPriorityChangeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DatabaseAccountInner> list() {
        PageImpl page = new PageImpl();
        page.setItems((List)((ServiceResponse)this.listWithServiceResponseAsync().toBlocking().single()).body());
        page.setNextPageLink(null);
        return new PagedList<DatabaseAccountInner>(page){

            public Page<DatabaseAccountInner> nextPage(String nextPageLink) {
                return null;
            }
        };
    }

    public ServiceFuture<List<DatabaseAccountInner>> listAsync(ServiceCallback<List<DatabaseAccountInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(), serviceCallback);
    }

    public Observable<Page<DatabaseAccountInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<List<DatabaseAccountInner>>, Page<DatabaseAccountInner>>(){

            public Page<DatabaseAccountInner> call(ServiceResponse<List<DatabaseAccountInner>> response) {
                PageImpl<DatabaseAccountInner> page = new PageImpl<DatabaseAccountInner>();
                page.setItems((List)response.body());
                return page;
            }
        });
    }

    public Observable<ServiceResponse<List<DatabaseAccountInner>>> listWithServiceResponseAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<DatabaseAccountInner>>>>(){

            public Observable<ServiceResponse<List<DatabaseAccountInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DatabaseAccountsInner.this.listDelegate((Response<ResponseBody>)response);
                    ServiceResponse clientResponse = new ServiceResponse(((PageImpl)result.body()).items(), result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DatabaseAccountInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DatabaseAccountInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DatabaseAccountInner> listByResourceGroup(String resourceGroupName) {
        PageImpl page = new PageImpl();
        page.setItems((List)((ServiceResponse)this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).toBlocking().single()).body());
        page.setNextPageLink(null);
        return new PagedList<DatabaseAccountInner>(page){

            public Page<DatabaseAccountInner> nextPage(String nextPageLink) {
                return null;
            }
        };
    }

    public ServiceFuture<List<DatabaseAccountInner>> listByResourceGroupAsync(String resourceGroupName, ServiceCallback<List<DatabaseAccountInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listByResourceGroupWithServiceResponseAsync(resourceGroupName), serviceCallback);
    }

    public Observable<Page<DatabaseAccountInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<List<DatabaseAccountInner>>, Page<DatabaseAccountInner>>(){

            public Page<DatabaseAccountInner> call(ServiceResponse<List<DatabaseAccountInner>> response) {
                PageImpl<DatabaseAccountInner> page = new PageImpl<DatabaseAccountInner>();
                page.setItems((List)response.body());
                return page;
            }
        });
    }

    public Observable<ServiceResponse<List<DatabaseAccountInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<DatabaseAccountInner>>>>(){

            public Observable<ServiceResponse<List<DatabaseAccountInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DatabaseAccountsInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    ServiceResponse clientResponse = new ServiceResponse(((PageImpl)result.body()).items(), result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DatabaseAccountInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DatabaseAccountInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DatabaseAccountListKeysResult listKeys(String resourceGroupName, String accountName) {
        return (DatabaseAccountListKeysResult)((ServiceResponse)this.listKeysWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    public ServiceFuture<DatabaseAccountListKeysResult> listKeysAsync(String resourceGroupName, String accountName, ServiceCallback<DatabaseAccountListKeysResult> serviceCallback) {
        return ServiceFuture.fromResponse(this.listKeysWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<DatabaseAccountListKeysResult> listKeysAsync(String resourceGroupName, String accountName) {
        return this.listKeysWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<DatabaseAccountListKeysResult>, DatabaseAccountListKeysResult>(){

            public DatabaseAccountListKeysResult call(ServiceResponse<DatabaseAccountListKeysResult> response) {
                return (DatabaseAccountListKeysResult)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DatabaseAccountListKeysResult>> listKeysWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listKeys(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseAccountListKeysResult>>>(){

            public Observable<ServiceResponse<DatabaseAccountListKeysResult>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.listKeysDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DatabaseAccountListKeysResult> listKeysDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DatabaseAccountListKeysResult>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DatabaseAccountListConnectionStringsResult listConnectionStrings(String resourceGroupName, String accountName) {
        return (DatabaseAccountListConnectionStringsResult)((ServiceResponse)this.listConnectionStringsWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    public ServiceFuture<DatabaseAccountListConnectionStringsResult> listConnectionStringsAsync(String resourceGroupName, String accountName, ServiceCallback<DatabaseAccountListConnectionStringsResult> serviceCallback) {
        return ServiceFuture.fromResponse(this.listConnectionStringsWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<DatabaseAccountListConnectionStringsResult> listConnectionStringsAsync(String resourceGroupName, String accountName) {
        return this.listConnectionStringsWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<DatabaseAccountListConnectionStringsResult>, DatabaseAccountListConnectionStringsResult>(){

            public DatabaseAccountListConnectionStringsResult call(ServiceResponse<DatabaseAccountListConnectionStringsResult> response) {
                return (DatabaseAccountListConnectionStringsResult)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DatabaseAccountListConnectionStringsResult>> listConnectionStringsWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listConnectionStrings(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseAccountListConnectionStringsResult>>>(){

            public Observable<ServiceResponse<DatabaseAccountListConnectionStringsResult>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.listConnectionStringsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DatabaseAccountListConnectionStringsResult> listConnectionStringsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DatabaseAccountListConnectionStringsResult>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DatabaseAccountListReadOnlyKeysResultInner listReadOnlyKeys(String resourceGroupName, String accountName) {
        return (DatabaseAccountListReadOnlyKeysResultInner)((ServiceResponse)this.listReadOnlyKeysWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    public ServiceFuture<DatabaseAccountListReadOnlyKeysResultInner> listReadOnlyKeysAsync(String resourceGroupName, String accountName, ServiceCallback<DatabaseAccountListReadOnlyKeysResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listReadOnlyKeysWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<DatabaseAccountListReadOnlyKeysResultInner> listReadOnlyKeysAsync(String resourceGroupName, String accountName) {
        return this.listReadOnlyKeysWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner>, DatabaseAccountListReadOnlyKeysResultInner>(){

            public DatabaseAccountListReadOnlyKeysResultInner call(ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner> response) {
                return (DatabaseAccountListReadOnlyKeysResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner>> listReadOnlyKeysWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listReadOnlyKeys(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner>>>(){

            public Observable<ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.listReadOnlyKeysDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner> listReadOnlyKeysDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DatabaseAccountListReadOnlyKeysResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void regenerateKey(String resourceGroupName, String accountName, KeyKind keyKind) {
        ((ServiceResponse)this.regenerateKeyWithServiceResponseAsync(resourceGroupName, accountName, keyKind).toBlocking().last()).body();
    }

    public ServiceFuture<Void> regenerateKeyAsync(String resourceGroupName, String accountName, KeyKind keyKind, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.regenerateKeyWithServiceResponseAsync(resourceGroupName, accountName, keyKind), serviceCallback);
    }

    public Observable<Void> regenerateKeyAsync(String resourceGroupName, String accountName, KeyKind keyKind) {
        return this.regenerateKeyWithServiceResponseAsync(resourceGroupName, accountName, keyKind).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> regenerateKeyWithServiceResponseAsync(String resourceGroupName, String accountName, KeyKind keyKind) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (keyKind == null) {
            throw new IllegalArgumentException("Parameter keyKind is required and cannot be null.");
        }
        DatabaseAccountRegenerateKeyParameters keyToRegenerate = new DatabaseAccountRegenerateKeyParameters();
        keyToRegenerate.withKeyKind(keyKind);
        Observable<Response<ResponseBody>> observable = this.service.regenerateKey(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), keyToRegenerate, this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginRegenerateKey(String resourceGroupName, String accountName, KeyKind keyKind) {
        ((ServiceResponse)this.beginRegenerateKeyWithServiceResponseAsync(resourceGroupName, accountName, keyKind).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginRegenerateKeyAsync(String resourceGroupName, String accountName, KeyKind keyKind, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginRegenerateKeyWithServiceResponseAsync(resourceGroupName, accountName, keyKind), serviceCallback);
    }

    public Observable<Void> beginRegenerateKeyAsync(String resourceGroupName, String accountName, KeyKind keyKind) {
        return this.beginRegenerateKeyWithServiceResponseAsync(resourceGroupName, accountName, keyKind).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginRegenerateKeyWithServiceResponseAsync(String resourceGroupName, String accountName, KeyKind keyKind) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (keyKind == null) {
            throw new IllegalArgumentException("Parameter keyKind is required and cannot be null.");
        }
        DatabaseAccountRegenerateKeyParameters keyToRegenerate = new DatabaseAccountRegenerateKeyParameters();
        keyToRegenerate.withKeyKind(keyKind);
        return this.service.beginRegenerateKey(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), keyToRegenerate, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginRegenerateKeyDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginRegenerateKeyDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public boolean checkNameExists(String accountName) {
        return (Boolean)((ServiceResponse)this.checkNameExistsWithServiceResponseAsync(accountName).toBlocking().single()).body();
    }

    public ServiceFuture<Boolean> checkNameExistsAsync(String accountName, ServiceCallback<Boolean> serviceCallback) {
        return ServiceFuture.fromResponse(this.checkNameExistsWithServiceResponseAsync(accountName), serviceCallback);
    }

    public Observable<Boolean> checkNameExistsAsync(String accountName) {
        return this.checkNameExistsWithServiceResponseAsync(accountName).map((Func1)new Func1<ServiceResponse<Boolean>, Boolean>(){

            public Boolean call(ServiceResponse<Boolean> response) {
                return (Boolean)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Boolean>> checkNameExistsWithServiceResponseAsync(String accountName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.checkNameExists(accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<Void>, Observable<ServiceResponse<Boolean>>>(){

            public Observable<ServiceResponse<Boolean>> call(Response<Void> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.checkNameExistsDelegate((Response<Void>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Boolean> checkNameExistsDelegate(Response<Void> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(404, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).buildEmpty(response);
    }

    static interface DatabaseAccountsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts patch"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}")
        public Observable<Response<ResponseBody>> patch(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body DatabaseAccountPatchParameters var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginPatch"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}")
        public Observable<Response<ResponseBody>> beginPatch(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body DatabaseAccountPatchParameters var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Body DatabaseAccountCreateUpdateParametersInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Body DatabaseAccountCreateUpdateParametersInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts failoverPriorityChange"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/failoverPriorityChange")
        public Observable<Response<ResponseBody>> failoverPriorityChange(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body FailoverPolicies var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginFailoverPriorityChange"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/failoverPriorityChange")
        public Observable<Response<ResponseBody>> beginFailoverPriorityChange(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body FailoverPolicies var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.DocumentDB/databaseAccounts")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listKeys"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/listKeys")
        public Observable<Response<ResponseBody>> listKeys(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listConnectionStrings"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/listConnectionStrings")
        public Observable<Response<ResponseBody>> listConnectionStrings(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listReadOnlyKeys"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/readonlykeys")
        public Observable<Response<ResponseBody>> listReadOnlyKeys(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts regenerateKey"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/regenerateKey")
        public Observable<Response<ResponseBody>> regenerateKey(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body DatabaseAccountRegenerateKeyParameters var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginRegenerateKey"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/regenerateKey")
        public Observable<Response<ResponseBody>> beginRegenerateKey(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body DatabaseAccountRegenerateKeyParameters var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts checkNameExists"})
        @HEAD(value="providers/Microsoft.DocumentDB/databaseAccountNames/{accountName}")
        public Observable<Response<Void>> checkNameExists(@Path(value="accountName") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);
    }
}

