/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.dns;

import com.microsoft.azure.management.dns.implementation.RecordSetInner;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Parameters supplied to update a record set.
 */
public class RecordSetUpdateParameters {
    /**
     * Specifies information about the record set being updated.
     */
    @JsonProperty(value = "RecordSet")
    private RecordSetInner recordSet;

    /**
     * Get the recordSet value.
     *
     * @return the recordSet value
     */
    public RecordSetInner recordSet() {
        return this.recordSet;
    }

    /**
     * Set the recordSet value.
     *
     * @param recordSet the recordSet value to set
     * @return the RecordSetUpdateParameters object itself.
     */
    public RecordSetUpdateParameters withRecordSet(RecordSetInner recordSet) {
        this.recordSet = recordSet;
        return this;
    }

}
