/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.graphrbac.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.graphrbac.GraphErrorException;
import com.microsoft.azure.management.graphrbac.KeyCredentialsUpdateParameters;
import com.microsoft.azure.management.graphrbac.PasswordCredentialsUpdateParameters;
import com.microsoft.azure.management.graphrbac.implementation.ApplicationCreateParametersInner;
import com.microsoft.azure.management.graphrbac.implementation.ApplicationInner;
import com.microsoft.azure.management.graphrbac.implementation.ApplicationUpdateParametersInner;
import com.microsoft.azure.management.graphrbac.implementation.GraphRbacManagementClientImpl;
import com.microsoft.azure.management.graphrbac.implementation.KeyCredentialInner;
import com.microsoft.azure.management.graphrbac.implementation.PageImpl;
import com.microsoft.azure.management.graphrbac.implementation.PageImpl1;
import com.microsoft.azure.management.graphrbac.implementation.PasswordCredentialInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class ApplicationsInner {
    private ApplicationsService service;
    private GraphRbacManagementClientImpl client;

    public ApplicationsInner(Retrofit retrofit, GraphRbacManagementClientImpl client) {
        this.service = (ApplicationsService)retrofit.create(ApplicationsService.class);
        this.client = client;
    }

    public ApplicationInner create(ApplicationCreateParametersInner parameters) {
        return (ApplicationInner)((ServiceResponse)this.createWithServiceResponseAsync(parameters).toBlocking().single()).body();
    }

    public ServiceFuture<ApplicationInner> createAsync(ApplicationCreateParametersInner parameters, ServiceCallback<ApplicationInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(parameters), serviceCallback);
    }

    public Observable<ApplicationInner> createAsync(ApplicationCreateParametersInner parameters) {
        return this.createWithServiceResponseAsync(parameters).map((Func1)new Func1<ServiceResponse<ApplicationInner>, ApplicationInner>(){

            public ApplicationInner call(ServiceResponse<ApplicationInner> response) {
                return (ApplicationInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ApplicationInner>> createWithServiceResponseAsync(ApplicationCreateParametersInner parameters) {
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.create(this.client.tenantID(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ApplicationInner>>>(){

            public Observable<ServiceResponse<ApplicationInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ApplicationsInner.this.createDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ApplicationInner> createDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(201, new TypeToken<ApplicationInner>(){}.getType()).registerError(GraphErrorException.class).build(response);
    }

    public PagedList<ApplicationInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<ApplicationInner>((Page)response.body()){

            public Page<ApplicationInner> nextPage(String nextLink) {
                return (Page)((ServiceResponse)ApplicationsInner.this.listNextSinglePageAsync(nextLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ApplicationInner>> listAsync(ListOperationCallback<ApplicationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<ApplicationInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationInner>>> call(String nextLink) {
                return ApplicationsInner.this.listNextSinglePageAsync(nextLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ApplicationInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<ApplicationInner>>, Page<ApplicationInner>>(){

            public Page<ApplicationInner> call(ServiceResponse<Page<ApplicationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<ApplicationInner>>, Observable<ServiceResponse<Page<ApplicationInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationInner>>> call(ServiceResponse<Page<ApplicationInner>> page) {
                String nextLink = ((Page)page.body()).nextPageLink();
                if (nextLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ApplicationsInner.this.listNextWithServiceResponseAsync(nextLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationInner>>> listSinglePageAsync() {
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String filter = null;
        return this.service.list(this.client.tenantID(), filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ApplicationInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ApplicationsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<ApplicationInner> list(String filter) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(filter).toBlocking().single();
        return new PagedList<ApplicationInner>((Page)response.body()){

            public Page<ApplicationInner> nextPage(String nextLink) {
                return (Page)((ServiceResponse)ApplicationsInner.this.listNextSinglePageAsync(nextLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ApplicationInner>> listAsync(String filter, ListOperationCallback<ApplicationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(filter), (Func1)new Func1<String, Observable<ServiceResponse<Page<ApplicationInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationInner>>> call(String nextLink) {
                return ApplicationsInner.this.listNextSinglePageAsync(nextLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ApplicationInner>> listAsync(String filter) {
        return this.listWithServiceResponseAsync(filter).map((Func1)new Func1<ServiceResponse<Page<ApplicationInner>>, Page<ApplicationInner>>(){

            public Page<ApplicationInner> call(ServiceResponse<Page<ApplicationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationInner>>> listWithServiceResponseAsync(String filter) {
        return this.listSinglePageAsync(filter).concatMap((Func1)new Func1<ServiceResponse<Page<ApplicationInner>>, Observable<ServiceResponse<Page<ApplicationInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationInner>>> call(ServiceResponse<Page<ApplicationInner>> page) {
                String nextLink = ((Page)page.body()).nextPageLink();
                if (nextLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ApplicationsInner.this.listNextWithServiceResponseAsync(nextLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationInner>>> listSinglePageAsync(String filter) {
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(this.client.tenantID(), filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ApplicationInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ApplicationsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ApplicationInner>> listDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ApplicationInner>>(){}.getType()).registerError(GraphErrorException.class).build(response);
    }

    public void delete(String applicationObjectId) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(applicationObjectId).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String applicationObjectId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(applicationObjectId), serviceCallback);
    }

    public Observable<Void> deleteAsync(String applicationObjectId) {
        return this.deleteWithServiceResponseAsync(applicationObjectId).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String applicationObjectId) {
        if (applicationObjectId == null) {
            throw new IllegalArgumentException("Parameter applicationObjectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.delete(applicationObjectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ApplicationsInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).registerError(GraphErrorException.class).build(response);
    }

    public ApplicationInner get(String applicationObjectId) {
        return (ApplicationInner)((ServiceResponse)this.getWithServiceResponseAsync(applicationObjectId).toBlocking().single()).body();
    }

    public ServiceFuture<ApplicationInner> getAsync(String applicationObjectId, ServiceCallback<ApplicationInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(applicationObjectId), serviceCallback);
    }

    public Observable<ApplicationInner> getAsync(String applicationObjectId) {
        return this.getWithServiceResponseAsync(applicationObjectId).map((Func1)new Func1<ServiceResponse<ApplicationInner>, ApplicationInner>(){

            public ApplicationInner call(ServiceResponse<ApplicationInner> response) {
                return (ApplicationInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ApplicationInner>> getWithServiceResponseAsync(String applicationObjectId) {
        if (applicationObjectId == null) {
            throw new IllegalArgumentException("Parameter applicationObjectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(applicationObjectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ApplicationInner>>>(){

            public Observable<ServiceResponse<ApplicationInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ApplicationsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ApplicationInner> getDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ApplicationInner>(){}.getType()).registerError(GraphErrorException.class).build(response);
    }

    public void patch(String applicationObjectId, ApplicationUpdateParametersInner parameters) {
        ((ServiceResponse)this.patchWithServiceResponseAsync(applicationObjectId, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<Void> patchAsync(String applicationObjectId, ApplicationUpdateParametersInner parameters, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.patchWithServiceResponseAsync(applicationObjectId, parameters), serviceCallback);
    }

    public Observable<Void> patchAsync(String applicationObjectId, ApplicationUpdateParametersInner parameters) {
        return this.patchWithServiceResponseAsync(applicationObjectId, parameters).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> patchWithServiceResponseAsync(String applicationObjectId, ApplicationUpdateParametersInner parameters) {
        if (applicationObjectId == null) {
            throw new IllegalArgumentException("Parameter applicationObjectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.patch(applicationObjectId, this.client.tenantID(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ApplicationsInner.this.patchDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> patchDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).registerError(GraphErrorException.class).build(response);
    }

    public List<KeyCredentialInner> listKeyCredentials(String applicationObjectId) {
        return (List)((ServiceResponse)this.listKeyCredentialsWithServiceResponseAsync(applicationObjectId).toBlocking().single()).body();
    }

    public ServiceFuture<List<KeyCredentialInner>> listKeyCredentialsAsync(String applicationObjectId, ServiceCallback<List<KeyCredentialInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listKeyCredentialsWithServiceResponseAsync(applicationObjectId), serviceCallback);
    }

    public Observable<List<KeyCredentialInner>> listKeyCredentialsAsync(String applicationObjectId) {
        return this.listKeyCredentialsWithServiceResponseAsync(applicationObjectId).map((Func1)new Func1<ServiceResponse<List<KeyCredentialInner>>, List<KeyCredentialInner>>(){

            public List<KeyCredentialInner> call(ServiceResponse<List<KeyCredentialInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<KeyCredentialInner>>> listKeyCredentialsWithServiceResponseAsync(String applicationObjectId) {
        if (applicationObjectId == null) {
            throw new IllegalArgumentException("Parameter applicationObjectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listKeyCredentials(applicationObjectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<KeyCredentialInner>>>>(){

            public Observable<ServiceResponse<List<KeyCredentialInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ApplicationsInner.this.listKeyCredentialsDelegate((Response<ResponseBody>)response);
                    ServiceResponse clientResponse = new ServiceResponse(((PageImpl1)result.body()).items(), result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<KeyCredentialInner>> listKeyCredentialsDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<KeyCredentialInner>>(){}.getType()).registerError(GraphErrorException.class).build(response);
    }

    public void updateKeyCredentials(String applicationObjectId, List<KeyCredentialInner> value) {
        ((ServiceResponse)this.updateKeyCredentialsWithServiceResponseAsync(applicationObjectId, value).toBlocking().single()).body();
    }

    public ServiceFuture<Void> updateKeyCredentialsAsync(String applicationObjectId, List<KeyCredentialInner> value, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateKeyCredentialsWithServiceResponseAsync(applicationObjectId, value), serviceCallback);
    }

    public Observable<Void> updateKeyCredentialsAsync(String applicationObjectId, List<KeyCredentialInner> value) {
        return this.updateKeyCredentialsWithServiceResponseAsync(applicationObjectId, value).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> updateKeyCredentialsWithServiceResponseAsync(String applicationObjectId, List<KeyCredentialInner> value) {
        if (applicationObjectId == null) {
            throw new IllegalArgumentException("Parameter applicationObjectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Parameter value is required and cannot be null.");
        }
        Validator.validate(value);
        KeyCredentialsUpdateParameters parameters = new KeyCredentialsUpdateParameters();
        parameters.withValue(value);
        return this.service.updateKeyCredentials(applicationObjectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ApplicationsInner.this.updateKeyCredentialsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> updateKeyCredentialsDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).registerError(GraphErrorException.class).build(response);
    }

    public List<PasswordCredentialInner> listPasswordCredentials(String applicationObjectId) {
        return (List)((ServiceResponse)this.listPasswordCredentialsWithServiceResponseAsync(applicationObjectId).toBlocking().single()).body();
    }

    public ServiceFuture<List<PasswordCredentialInner>> listPasswordCredentialsAsync(String applicationObjectId, ServiceCallback<List<PasswordCredentialInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listPasswordCredentialsWithServiceResponseAsync(applicationObjectId), serviceCallback);
    }

    public Observable<List<PasswordCredentialInner>> listPasswordCredentialsAsync(String applicationObjectId) {
        return this.listPasswordCredentialsWithServiceResponseAsync(applicationObjectId).map((Func1)new Func1<ServiceResponse<List<PasswordCredentialInner>>, List<PasswordCredentialInner>>(){

            public List<PasswordCredentialInner> call(ServiceResponse<List<PasswordCredentialInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<PasswordCredentialInner>>> listPasswordCredentialsWithServiceResponseAsync(String applicationObjectId) {
        if (applicationObjectId == null) {
            throw new IllegalArgumentException("Parameter applicationObjectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listPasswordCredentials(applicationObjectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<PasswordCredentialInner>>>>(){

            public Observable<ServiceResponse<List<PasswordCredentialInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ApplicationsInner.this.listPasswordCredentialsDelegate((Response<ResponseBody>)response);
                    ServiceResponse clientResponse = new ServiceResponse(((PageImpl1)result.body()).items(), result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<PasswordCredentialInner>> listPasswordCredentialsDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<PasswordCredentialInner>>(){}.getType()).registerError(GraphErrorException.class).build(response);
    }

    public void updatePasswordCredentials(String applicationObjectId, List<PasswordCredentialInner> value) {
        ((ServiceResponse)this.updatePasswordCredentialsWithServiceResponseAsync(applicationObjectId, value).toBlocking().single()).body();
    }

    public ServiceFuture<Void> updatePasswordCredentialsAsync(String applicationObjectId, List<PasswordCredentialInner> value, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.updatePasswordCredentialsWithServiceResponseAsync(applicationObjectId, value), serviceCallback);
    }

    public Observable<Void> updatePasswordCredentialsAsync(String applicationObjectId, List<PasswordCredentialInner> value) {
        return this.updatePasswordCredentialsWithServiceResponseAsync(applicationObjectId, value).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> updatePasswordCredentialsWithServiceResponseAsync(String applicationObjectId, List<PasswordCredentialInner> value) {
        if (applicationObjectId == null) {
            throw new IllegalArgumentException("Parameter applicationObjectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Parameter value is required and cannot be null.");
        }
        Validator.validate(value);
        PasswordCredentialsUpdateParameters parameters = new PasswordCredentialsUpdateParameters();
        parameters.withValue(value);
        return this.service.updatePasswordCredentials(applicationObjectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ApplicationsInner.this.updatePasswordCredentialsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> updatePasswordCredentialsDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).registerError(GraphErrorException.class).build(response);
    }

    public PagedList<ApplicationInner> listNext(String nextLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextLink).toBlocking().single();
        return new PagedList<ApplicationInner>((Page)response.body()){

            public Page<ApplicationInner> nextPage(String nextLink) {
                return (Page)((ServiceResponse)ApplicationsInner.this.listNextSinglePageAsync(nextLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ApplicationInner>> listNextAsync(String nextLink, ServiceFuture<List<ApplicationInner>> serviceFuture, ListOperationCallback<ApplicationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ApplicationInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationInner>>> call(String nextLink) {
                return ApplicationsInner.this.listNextSinglePageAsync(nextLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ApplicationInner>> listNextAsync(String nextLink) {
        return this.listNextWithServiceResponseAsync(nextLink).map((Func1)new Func1<ServiceResponse<Page<ApplicationInner>>, Page<ApplicationInner>>(){

            public Page<ApplicationInner> call(ServiceResponse<Page<ApplicationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationInner>>> listNextWithServiceResponseAsync(String nextLink) {
        return this.listNextSinglePageAsync(nextLink).concatMap((Func1)new Func1<ServiceResponse<Page<ApplicationInner>>, Observable<ServiceResponse<Page<ApplicationInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationInner>>> call(ServiceResponse<Page<ApplicationInner>> page) {
                String nextLink = ((Page)page.body()).nextPageLink();
                if (nextLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ApplicationsInner.this.listNextWithServiceResponseAsync(nextLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationInner>>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            throw new IllegalArgumentException("Parameter nextLink is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String nextUrl = String.format("%s/%s", this.client.tenantID(), nextLink);
        return this.service.listNext(nextUrl, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ApplicationInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ApplicationsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ApplicationInner>> listNextDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ApplicationInner>>(){}.getType()).registerError(GraphErrorException.class).build(response);
    }

    static interface ApplicationsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Applications create"})
        @POST(value="{tenantID}/applications")
        public Observable<Response<ResponseBody>> create(@Path(value="tenantID") String var1, @Body ApplicationCreateParametersInner var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Applications list"})
        @GET(value="{tenantID}/applications")
        public Observable<Response<ResponseBody>> list(@Path(value="tenantID") String var1, @Query(value="$filter") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Applications delete"})
        @HTTP(path="{tenantID}/applications/{applicationObjectId}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="applicationObjectId", encoded=true) String var1, @Path(value="tenantID") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Applications get"})
        @GET(value="{tenantID}/applications/{applicationObjectId}")
        public Observable<Response<ResponseBody>> get(@Path(value="applicationObjectId", encoded=true) String var1, @Path(value="tenantID") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Applications patch"})
        @PATCH(value="{tenantID}/applications/{applicationObjectId}")
        public Observable<Response<ResponseBody>> patch(@Path(value="applicationObjectId", encoded=true) String var1, @Path(value="tenantID") String var2, @Body ApplicationUpdateParametersInner var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Applications listKeyCredentials"})
        @GET(value="{tenantID}/applications/{applicationObjectId}/keyCredentials")
        public Observable<Response<ResponseBody>> listKeyCredentials(@Path(value="applicationObjectId", encoded=true) String var1, @Path(value="tenantID") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Applications updateKeyCredentials"})
        @PATCH(value="{tenantID}/applications/{applicationObjectId}/keyCredentials")
        public Observable<Response<ResponseBody>> updateKeyCredentials(@Path(value="applicationObjectId", encoded=true) String var1, @Path(value="tenantID") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Body KeyCredentialsUpdateParameters var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Applications listPasswordCredentials"})
        @GET(value="{tenantID}/applications/{applicationObjectId}/passwordCredentials")
        public Observable<Response<ResponseBody>> listPasswordCredentials(@Path(value="applicationObjectId", encoded=true) String var1, @Path(value="tenantID") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Applications updatePasswordCredentials"})
        @PATCH(value="{tenantID}/applications/{applicationObjectId}/passwordCredentials")
        public Observable<Response<ResponseBody>> updatePasswordCredentials(@Path(value="applicationObjectId", encoded=true) String var1, @Path(value="tenantID") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Body PasswordCredentialsUpdateParameters var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Applications listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);
    }
}

