// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;


import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Device Configuration Get Oma Setting Plain Text Value Parameter Set.
 */
public class DeviceConfigurationGetOmaSettingPlainTextValueParameterSet {
    /**
     * The secret Reference Value Id.
     * 
     */
    @SerializedName(value = "secretReferenceValueId", alternate = {"SecretReferenceValueId"})
    @Expose
	@Nullable
    public String secretReferenceValueId;


    /**
     * Instiaciates a new DeviceConfigurationGetOmaSettingPlainTextValueParameterSet
     */
    public DeviceConfigurationGetOmaSettingPlainTextValueParameterSet() {}
    /**
     * Instiaciates a new DeviceConfigurationGetOmaSettingPlainTextValueParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected DeviceConfigurationGetOmaSettingPlainTextValueParameterSet(@Nonnull final DeviceConfigurationGetOmaSettingPlainTextValueParameterSetBuilder builder) {
        this.secretReferenceValueId = builder.secretReferenceValueId;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static DeviceConfigurationGetOmaSettingPlainTextValueParameterSetBuilder newBuilder() {
        return new DeviceConfigurationGetOmaSettingPlainTextValueParameterSetBuilder();
    }
    /**
     * Fluent builder for the DeviceConfigurationGetOmaSettingPlainTextValueParameterSet
     */
    public static final class DeviceConfigurationGetOmaSettingPlainTextValueParameterSetBuilder {
        /**
         * The secretReferenceValueId parameter value
         */
        @Nullable
        protected String secretReferenceValueId;
        /**
         * Sets the SecretReferenceValueId
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public DeviceConfigurationGetOmaSettingPlainTextValueParameterSetBuilder withSecretReferenceValueId(@Nullable final String val) {
            this.secretReferenceValueId = val;
            return this;
        }
        /**
         * Instanciates a new DeviceConfigurationGetOmaSettingPlainTextValueParameterSetBuilder
         */
        @Nullable
        protected DeviceConfigurationGetOmaSettingPlainTextValueParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public DeviceConfigurationGetOmaSettingPlainTextValueParameterSet build() {
            return new DeviceConfigurationGetOmaSettingPlainTextValueParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.secretReferenceValueId != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("secretReferenceValueId", secretReferenceValueId));
        }
        return result;
    }
}
