// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.DayOfWeek;
import com.microsoft.graph.models.DeviceConfiguration;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Ios Update Configuration.
 */
public class IosUpdateConfiguration extends DeviceConfiguration implements IJsonBackedObject {


    /**
     * The Active Hours End.
     * Active Hours End (active hours mean the time window when updates install should not happen)
     */
    @SerializedName(value = "activeHoursEnd", alternate = {"ActiveHoursEnd"})
    @Expose
	@Nullable
    public com.microsoft.graph.core.TimeOfDay activeHoursEnd;

    /**
     * The Active Hours Start.
     * Active Hours Start (active hours mean the time window when updates install should not happen)
     */
    @SerializedName(value = "activeHoursStart", alternate = {"ActiveHoursStart"})
    @Expose
	@Nullable
    public com.microsoft.graph.core.TimeOfDay activeHoursStart;

    /**
     * The Scheduled Install Days.
     * Days in week for which active hours are configured. This collection can contain a maximum of 7 elements.
     */
    @SerializedName(value = "scheduledInstallDays", alternate = {"ScheduledInstallDays"})
    @Expose
	@Nullable
    public java.util.List<DayOfWeek> scheduledInstallDays;

    /**
     * The Utc Time Offset In Minutes.
     * UTC Time Offset indicated in minutes
     */
    @SerializedName(value = "utcTimeOffsetInMinutes", alternate = {"UtcTimeOffsetInMinutes"})
    @Expose
	@Nullable
    public Integer utcTimeOffsetInMinutes;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
