// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;


import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Managed Device Delete User From Shared Apple Device Parameter Set.
 */
public class ManagedDeviceDeleteUserFromSharedAppleDeviceParameterSet {
    /**
     * The user Principal Name.
     * 
     */
    @SerializedName(value = "userPrincipalName", alternate = {"UserPrincipalName"})
    @Expose
	@Nullable
    public String userPrincipalName;


    /**
     * Instiaciates a new ManagedDeviceDeleteUserFromSharedAppleDeviceParameterSet
     */
    public ManagedDeviceDeleteUserFromSharedAppleDeviceParameterSet() {}
    /**
     * Instiaciates a new ManagedDeviceDeleteUserFromSharedAppleDeviceParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected ManagedDeviceDeleteUserFromSharedAppleDeviceParameterSet(@Nonnull final ManagedDeviceDeleteUserFromSharedAppleDeviceParameterSetBuilder builder) {
        this.userPrincipalName = builder.userPrincipalName;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static ManagedDeviceDeleteUserFromSharedAppleDeviceParameterSetBuilder newBuilder() {
        return new ManagedDeviceDeleteUserFromSharedAppleDeviceParameterSetBuilder();
    }
    /**
     * Fluent builder for the ManagedDeviceDeleteUserFromSharedAppleDeviceParameterSet
     */
    public static final class ManagedDeviceDeleteUserFromSharedAppleDeviceParameterSetBuilder {
        /**
         * The userPrincipalName parameter value
         */
        @Nullable
        protected String userPrincipalName;
        /**
         * Sets the UserPrincipalName
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public ManagedDeviceDeleteUserFromSharedAppleDeviceParameterSetBuilder withUserPrincipalName(@Nullable final String val) {
            this.userPrincipalName = val;
            return this;
        }
        /**
         * Instanciates a new ManagedDeviceDeleteUserFromSharedAppleDeviceParameterSetBuilder
         */
        @Nullable
        protected ManagedDeviceDeleteUserFromSharedAppleDeviceParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public ManagedDeviceDeleteUserFromSharedAppleDeviceParameterSet build() {
            return new ManagedDeviceDeleteUserFromSharedAppleDeviceParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.userPrincipalName != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("userPrincipalName", userPrincipalName));
        }
        return result;
    }
}
