// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Setting State Device Summary.
 */
public class SettingStateDeviceSummary extends Entity implements IJsonBackedObject {


    /**
     * The Compliant Device Count.
     * Device Compliant count for the setting
     */
    @SerializedName(value = "compliantDeviceCount", alternate = {"CompliantDeviceCount"})
    @Expose
	@Nullable
    public Integer compliantDeviceCount;

    /**
     * The Conflict Device Count.
     * Device conflict error count for the setting
     */
    @SerializedName(value = "conflictDeviceCount", alternate = {"ConflictDeviceCount"})
    @Expose
	@Nullable
    public Integer conflictDeviceCount;

    /**
     * The Error Device Count.
     * Device error count for the setting
     */
    @SerializedName(value = "errorDeviceCount", alternate = {"ErrorDeviceCount"})
    @Expose
	@Nullable
    public Integer errorDeviceCount;

    /**
     * The Instance Path.
     * Name of the InstancePath for the setting
     */
    @SerializedName(value = "instancePath", alternate = {"InstancePath"})
    @Expose
	@Nullable
    public String instancePath;

    /**
     * The Non Compliant Device Count.
     * Device NonCompliant count for the setting
     */
    @SerializedName(value = "nonCompliantDeviceCount", alternate = {"NonCompliantDeviceCount"})
    @Expose
	@Nullable
    public Integer nonCompliantDeviceCount;

    /**
     * The Not Applicable Device Count.
     * Device Not Applicable count for the setting
     */
    @SerializedName(value = "notApplicableDeviceCount", alternate = {"NotApplicableDeviceCount"})
    @Expose
	@Nullable
    public Integer notApplicableDeviceCount;

    /**
     * The Remediated Device Count.
     * Device Compliant count for the setting
     */
    @SerializedName(value = "remediatedDeviceCount", alternate = {"RemediatedDeviceCount"})
    @Expose
	@Nullable
    public Integer remediatedDeviceCount;

    /**
     * The Setting Name.
     * Name of the setting
     */
    @SerializedName(value = "settingName", alternate = {"SettingName"})
    @Expose
	@Nullable
    public String settingName;

    /**
     * The Unknown Device Count.
     * Device Unkown count for the setting
     */
    @SerializedName(value = "unknownDeviceCount", alternate = {"UnknownDeviceCount"})
    @Expose
	@Nullable
    public Integer unknownDeviceCount;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
