// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.WorkbookFunctionResult;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Functions Choose Parameter Set.
 */
public class WorkbookFunctionsChooseParameterSet {
    /**
     * The index Num.
     * 
     */
    @SerializedName(value = "indexNum", alternate = {"IndexNum"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement indexNum;

    /**
     * The values.
     * 
     */
    @SerializedName(value = "values", alternate = {"Values"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement values;


    /**
     * Instiaciates a new WorkbookFunctionsChooseParameterSet
     */
    public WorkbookFunctionsChooseParameterSet() {}
    /**
     * Instiaciates a new WorkbookFunctionsChooseParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookFunctionsChooseParameterSet(@Nonnull final WorkbookFunctionsChooseParameterSetBuilder builder) {
        this.indexNum = builder.indexNum;
        this.values = builder.values;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookFunctionsChooseParameterSetBuilder newBuilder() {
        return new WorkbookFunctionsChooseParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookFunctionsChooseParameterSet
     */
    public static final class WorkbookFunctionsChooseParameterSetBuilder {
        /**
         * The indexNum parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement indexNum;
        /**
         * Sets the IndexNum
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsChooseParameterSetBuilder withIndexNum(@Nullable final com.google.gson.JsonElement val) {
            this.indexNum = val;
            return this;
        }
        /**
         * The values parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement values;
        /**
         * Sets the Values
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsChooseParameterSetBuilder withValues(@Nullable final com.google.gson.JsonElement val) {
            this.values = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookFunctionsChooseParameterSetBuilder
         */
        @Nullable
        protected WorkbookFunctionsChooseParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookFunctionsChooseParameterSet build() {
            return new WorkbookFunctionsChooseParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.indexNum != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("indexNum", indexNum));
        }
        if(this.values != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("values", values));
        }
        return result;
    }
}
