// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.WorkbookFunctionResult;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Functions Find Parameter Set.
 */
public class WorkbookFunctionsFindParameterSet {
    /**
     * The find Text.
     * 
     */
    @SerializedName(value = "findText", alternate = {"FindText"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement findText;

    /**
     * The within Text.
     * 
     */
    @SerializedName(value = "withinText", alternate = {"WithinText"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement withinText;

    /**
     * The start Num.
     * 
     */
    @SerializedName(value = "startNum", alternate = {"StartNum"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement startNum;


    /**
     * Instiaciates a new WorkbookFunctionsFindParameterSet
     */
    public WorkbookFunctionsFindParameterSet() {}
    /**
     * Instiaciates a new WorkbookFunctionsFindParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookFunctionsFindParameterSet(@Nonnull final WorkbookFunctionsFindParameterSetBuilder builder) {
        this.findText = builder.findText;
        this.withinText = builder.withinText;
        this.startNum = builder.startNum;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookFunctionsFindParameterSetBuilder newBuilder() {
        return new WorkbookFunctionsFindParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookFunctionsFindParameterSet
     */
    public static final class WorkbookFunctionsFindParameterSetBuilder {
        /**
         * The findText parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement findText;
        /**
         * Sets the FindText
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsFindParameterSetBuilder withFindText(@Nullable final com.google.gson.JsonElement val) {
            this.findText = val;
            return this;
        }
        /**
         * The withinText parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement withinText;
        /**
         * Sets the WithinText
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsFindParameterSetBuilder withWithinText(@Nullable final com.google.gson.JsonElement val) {
            this.withinText = val;
            return this;
        }
        /**
         * The startNum parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement startNum;
        /**
         * Sets the StartNum
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsFindParameterSetBuilder withStartNum(@Nullable final com.google.gson.JsonElement val) {
            this.startNum = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookFunctionsFindParameterSetBuilder
         */
        @Nullable
        protected WorkbookFunctionsFindParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookFunctionsFindParameterSet build() {
            return new WorkbookFunctionsFindParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.findText != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("findText", findText));
        }
        if(this.withinText != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("withinText", withinText));
        }
        if(this.startNum != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("startNum", startNum));
        }
        return result;
    }
}
