// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.WorkbookWorksheetProtectionOptions;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Worksheet Protection Protect Parameter Set.
 */
public class WorkbookWorksheetProtectionProtectParameterSet {
    /**
     * The options.
     * 
     */
    @SerializedName(value = "options", alternate = {"Options"})
    @Expose
	@Nullable
    public WorkbookWorksheetProtectionOptions options;


    /**
     * Instiaciates a new WorkbookWorksheetProtectionProtectParameterSet
     */
    public WorkbookWorksheetProtectionProtectParameterSet() {}
    /**
     * Instiaciates a new WorkbookWorksheetProtectionProtectParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookWorksheetProtectionProtectParameterSet(@Nonnull final WorkbookWorksheetProtectionProtectParameterSetBuilder builder) {
        this.options = builder.options;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookWorksheetProtectionProtectParameterSetBuilder newBuilder() {
        return new WorkbookWorksheetProtectionProtectParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookWorksheetProtectionProtectParameterSet
     */
    public static final class WorkbookWorksheetProtectionProtectParameterSetBuilder {
        /**
         * The options parameter value
         */
        @Nullable
        protected WorkbookWorksheetProtectionOptions options;
        /**
         * Sets the Options
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookWorksheetProtectionProtectParameterSetBuilder withOptions(@Nullable final WorkbookWorksheetProtectionOptions val) {
            this.options = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookWorksheetProtectionProtectParameterSetBuilder
         */
        @Nullable
        protected WorkbookWorksheetProtectionProtectParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookWorksheetProtectionProtectParameterSet build() {
            return new WorkbookWorksheetProtectionProtectParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.options != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("options", options));
        }
        return result;
    }
}
