// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AuthenticationFlowsPolicy;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Authentication Flows Policy Request.
 */
public class AuthenticationFlowsPolicyRequest extends BaseRequest<AuthenticationFlowsPolicy> {
	
    /**
     * The request for the AuthenticationFlowsPolicy
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AuthenticationFlowsPolicyRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AuthenticationFlowsPolicy.class);
    }

    /**
     * Gets the AuthenticationFlowsPolicy from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AuthenticationFlowsPolicy> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the AuthenticationFlowsPolicy from the service
     *
     * @return the AuthenticationFlowsPolicy from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AuthenticationFlowsPolicy get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AuthenticationFlowsPolicy> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public AuthenticationFlowsPolicy delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this AuthenticationFlowsPolicy with a source
     *
     * @param sourceAuthenticationFlowsPolicy the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AuthenticationFlowsPolicy> patchAsync(@Nonnull final AuthenticationFlowsPolicy sourceAuthenticationFlowsPolicy) {
        return sendAsync(HttpMethod.PATCH, sourceAuthenticationFlowsPolicy);
    }

    /**
     * Patches this AuthenticationFlowsPolicy with a source
     *
     * @param sourceAuthenticationFlowsPolicy the source object with updates
     * @return the updated AuthenticationFlowsPolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AuthenticationFlowsPolicy patch(@Nonnull final AuthenticationFlowsPolicy sourceAuthenticationFlowsPolicy) throws ClientException {
        return send(HttpMethod.PATCH, sourceAuthenticationFlowsPolicy);
    }

    /**
     * Creates a AuthenticationFlowsPolicy with a new object
     *
     * @param newAuthenticationFlowsPolicy the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AuthenticationFlowsPolicy> postAsync(@Nonnull final AuthenticationFlowsPolicy newAuthenticationFlowsPolicy) {
        return sendAsync(HttpMethod.POST, newAuthenticationFlowsPolicy);
    }

    /**
     * Creates a AuthenticationFlowsPolicy with a new object
     *
     * @param newAuthenticationFlowsPolicy the new object to create
     * @return the created AuthenticationFlowsPolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AuthenticationFlowsPolicy post(@Nonnull final AuthenticationFlowsPolicy newAuthenticationFlowsPolicy) throws ClientException {
        return send(HttpMethod.POST, newAuthenticationFlowsPolicy);
    }

    /**
     * Creates a AuthenticationFlowsPolicy with a new object
     *
     * @param newAuthenticationFlowsPolicy the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AuthenticationFlowsPolicy> putAsync(@Nonnull final AuthenticationFlowsPolicy newAuthenticationFlowsPolicy) {
        return sendAsync(HttpMethod.PUT, newAuthenticationFlowsPolicy);
    }

    /**
     * Creates a AuthenticationFlowsPolicy with a new object
     *
     * @param newAuthenticationFlowsPolicy the object to create/update
     * @return the created AuthenticationFlowsPolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AuthenticationFlowsPolicy put(@Nonnull final AuthenticationFlowsPolicy newAuthenticationFlowsPolicy) throws ClientException {
        return send(HttpMethod.PUT, newAuthenticationFlowsPolicy);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public AuthenticationFlowsPolicyRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public AuthenticationFlowsPolicyRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

