// Template Source: BaseEntityCollectionRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.IdentityContainer;
import com.microsoft.graph.models.B2xIdentityUserFlow;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.requests.B2xIdentityUserFlowCollectionResponse;
import com.microsoft.graph.requests.B2xIdentityUserFlowCollectionRequestBuilder;
import com.microsoft.graph.requests.B2xIdentityUserFlowCollectionRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the B2x Identity User Flow Collection Request.
 */
public class B2xIdentityUserFlowCollectionRequest extends BaseEntityCollectionRequest<B2xIdentityUserFlow, B2xIdentityUserFlowCollectionResponse, B2xIdentityUserFlowCollectionPage> {

    /**
     * The request builder for this collection of B2xIdentityUserFlow
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public B2xIdentityUserFlowCollectionRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, B2xIdentityUserFlowCollectionResponse.class, B2xIdentityUserFlowCollectionPage.class, B2xIdentityUserFlowCollectionRequestBuilder.class);
    }

    /**
     * Creates a new B2xIdentityUserFlow
     * @param newB2xIdentityUserFlow the B2xIdentityUserFlow to create
     * @return a future with the created object
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<B2xIdentityUserFlow> postAsync(@Nonnull final B2xIdentityUserFlow newB2xIdentityUserFlow) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new B2xIdentityUserFlowRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getHeaders())
            .postAsync(newB2xIdentityUserFlow);
    }

    /**
     * Creates a new B2xIdentityUserFlow
     * @param newB2xIdentityUserFlow the B2xIdentityUserFlow to create
     * @return the newly created object
     */
    @Nonnull
    public B2xIdentityUserFlow post(@Nonnull final B2xIdentityUserFlow newB2xIdentityUserFlow) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new B2xIdentityUserFlowRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getHeaders())
            .post(newB2xIdentityUserFlow);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    @Nonnull
    public B2xIdentityUserFlowCollectionRequest expand(@Nonnull final String value) {
        addExpandOption(value);
        return this;
    }

    /**
     * Sets the filter clause for the request
     *
     * @param value the filter clause
     * @return the updated request
     */
    @Nonnull
    public B2xIdentityUserFlowCollectionRequest filter(@Nonnull final String value) {
        addFilterOption(value);
        return this;
    }

    /**
     * Sets the order by clause for the request
     *
     * @param value the order by clause
     * @return the updated request
     */
    @Nonnull
    public B2xIdentityUserFlowCollectionRequest orderBy(@Nonnull final String value) {
        addOrderByOption(value);
        return this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    @Nonnull
    public B2xIdentityUserFlowCollectionRequest select(@Nonnull final String value) {
        addSelectOption(value);
        return this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value the max number of items to return
     * @return the updated request
     */
    @Nonnull
    public B2xIdentityUserFlowCollectionRequest top(final int value) {
        addTopOption(value);
        return this;
    }

    /**
     * Sets the count value for the request
     *
     * @param value whether or not to return the count of objects with the request
     * @return the updated request
     */
    @Nonnull
    public B2xIdentityUserFlowCollectionRequest count(final boolean value) {
        addCountOption(value);
        return this;
    }
    /**
     * Sets the count value to true for the request
     *
     * @return the updated request
     */
    @Nonnull
    public B2xIdentityUserFlowCollectionRequest count() {
        addCountOption(true);
        return this;
    }
    /**
     * Sets the skip value for the request
     *
     * @param value of the number of items to skip
     * @return the updated request
     */
    @Nonnull
    public B2xIdentityUserFlowCollectionRequest skip(final int value) {
        addSkipOption(value);
        return this;
    }


    /**
     * Add Skip token for pagination
     * @param skipToken - Token for pagination
     * @return the updated request
     */
    @Nonnull
    public B2xIdentityUserFlowCollectionRequest skipToken(@Nonnull final String skipToken) {
    	addSkipTokenOption(skipToken);
        return this;
    }
}

