// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.GroupLifecyclePolicy;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Group Lifecycle Policy Request.
 */
public class GroupLifecyclePolicyRequest extends BaseRequest<GroupLifecyclePolicy> {
	
    /**
     * The request for the GroupLifecyclePolicy
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public GroupLifecyclePolicyRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, GroupLifecyclePolicy.class);
    }

    /**
     * Gets the GroupLifecyclePolicy from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<GroupLifecyclePolicy> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the GroupLifecyclePolicy from the service
     *
     * @return the GroupLifecyclePolicy from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public GroupLifecyclePolicy get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<GroupLifecyclePolicy> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public GroupLifecyclePolicy delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this GroupLifecyclePolicy with a source
     *
     * @param sourceGroupLifecyclePolicy the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<GroupLifecyclePolicy> patchAsync(@Nonnull final GroupLifecyclePolicy sourceGroupLifecyclePolicy) {
        return sendAsync(HttpMethod.PATCH, sourceGroupLifecyclePolicy);
    }

    /**
     * Patches this GroupLifecyclePolicy with a source
     *
     * @param sourceGroupLifecyclePolicy the source object with updates
     * @return the updated GroupLifecyclePolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public GroupLifecyclePolicy patch(@Nonnull final GroupLifecyclePolicy sourceGroupLifecyclePolicy) throws ClientException {
        return send(HttpMethod.PATCH, sourceGroupLifecyclePolicy);
    }

    /**
     * Creates a GroupLifecyclePolicy with a new object
     *
     * @param newGroupLifecyclePolicy the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<GroupLifecyclePolicy> postAsync(@Nonnull final GroupLifecyclePolicy newGroupLifecyclePolicy) {
        return sendAsync(HttpMethod.POST, newGroupLifecyclePolicy);
    }

    /**
     * Creates a GroupLifecyclePolicy with a new object
     *
     * @param newGroupLifecyclePolicy the new object to create
     * @return the created GroupLifecyclePolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public GroupLifecyclePolicy post(@Nonnull final GroupLifecyclePolicy newGroupLifecyclePolicy) throws ClientException {
        return send(HttpMethod.POST, newGroupLifecyclePolicy);
    }

    /**
     * Creates a GroupLifecyclePolicy with a new object
     *
     * @param newGroupLifecyclePolicy the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<GroupLifecyclePolicy> putAsync(@Nonnull final GroupLifecyclePolicy newGroupLifecyclePolicy) {
        return sendAsync(HttpMethod.PUT, newGroupLifecyclePolicy);
    }

    /**
     * Creates a GroupLifecyclePolicy with a new object
     *
     * @param newGroupLifecyclePolicy the object to create/update
     * @return the created GroupLifecyclePolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public GroupLifecyclePolicy put(@Nonnull final GroupLifecyclePolicy newGroupLifecyclePolicy) throws ClientException {
        return send(HttpMethod.PUT, newGroupLifecyclePolicy);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public GroupLifecyclePolicyRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public GroupLifecyclePolicyRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

