// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.OnlineMeeting;
import com.microsoft.graph.models.ChatInfo;
import com.microsoft.graph.models.MeetingParticipants;
import com.microsoft.graph.requests.MeetingAttendanceReportCollectionRequestBuilder;
import com.microsoft.graph.requests.MeetingAttendanceReportRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Online Meeting Request.
 */
public class OnlineMeetingRequest extends BaseRequest<OnlineMeeting> {
	
    /**
     * The request for the OnlineMeeting
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public OnlineMeetingRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, OnlineMeeting.class);
    }

    /**
     * Gets the OnlineMeeting from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<OnlineMeeting> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the OnlineMeeting from the service
     *
     * @return the OnlineMeeting from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public OnlineMeeting get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<OnlineMeeting> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public OnlineMeeting delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this OnlineMeeting with a source
     *
     * @param sourceOnlineMeeting the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<OnlineMeeting> patchAsync(@Nonnull final OnlineMeeting sourceOnlineMeeting) {
        return sendAsync(HttpMethod.PATCH, sourceOnlineMeeting);
    }

    /**
     * Patches this OnlineMeeting with a source
     *
     * @param sourceOnlineMeeting the source object with updates
     * @return the updated OnlineMeeting
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public OnlineMeeting patch(@Nonnull final OnlineMeeting sourceOnlineMeeting) throws ClientException {
        return send(HttpMethod.PATCH, sourceOnlineMeeting);
    }

    /**
     * Creates a OnlineMeeting with a new object
     *
     * @param newOnlineMeeting the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<OnlineMeeting> postAsync(@Nonnull final OnlineMeeting newOnlineMeeting) {
        return sendAsync(HttpMethod.POST, newOnlineMeeting);
    }

    /**
     * Creates a OnlineMeeting with a new object
     *
     * @param newOnlineMeeting the new object to create
     * @return the created OnlineMeeting
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public OnlineMeeting post(@Nonnull final OnlineMeeting newOnlineMeeting) throws ClientException {
        return send(HttpMethod.POST, newOnlineMeeting);
    }

    /**
     * Creates a OnlineMeeting with a new object
     *
     * @param newOnlineMeeting the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<OnlineMeeting> putAsync(@Nonnull final OnlineMeeting newOnlineMeeting) {
        return sendAsync(HttpMethod.PUT, newOnlineMeeting);
    }

    /**
     * Creates a OnlineMeeting with a new object
     *
     * @param newOnlineMeeting the object to create/update
     * @return the created OnlineMeeting
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public OnlineMeeting put(@Nonnull final OnlineMeeting newOnlineMeeting) throws ClientException {
        return send(HttpMethod.PUT, newOnlineMeeting);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public OnlineMeetingRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public OnlineMeetingRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

