// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.WorkbookChartPointFormat;
import com.microsoft.graph.requests.WorkbookChartFillRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Chart Point Format Request.
 */
public class WorkbookChartPointFormatRequest extends BaseRequest<WorkbookChartPointFormat> {
	
    /**
     * The request for the WorkbookChartPointFormat
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WorkbookChartPointFormatRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, WorkbookChartPointFormat.class);
    }

    /**
     * Gets the WorkbookChartPointFormat from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookChartPointFormat> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the WorkbookChartPointFormat from the service
     *
     * @return the WorkbookChartPointFormat from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookChartPointFormat get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookChartPointFormat> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public WorkbookChartPointFormat delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this WorkbookChartPointFormat with a source
     *
     * @param sourceWorkbookChartPointFormat the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookChartPointFormat> patchAsync(@Nonnull final WorkbookChartPointFormat sourceWorkbookChartPointFormat) {
        return sendAsync(HttpMethod.PATCH, sourceWorkbookChartPointFormat);
    }

    /**
     * Patches this WorkbookChartPointFormat with a source
     *
     * @param sourceWorkbookChartPointFormat the source object with updates
     * @return the updated WorkbookChartPointFormat
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookChartPointFormat patch(@Nonnull final WorkbookChartPointFormat sourceWorkbookChartPointFormat) throws ClientException {
        return send(HttpMethod.PATCH, sourceWorkbookChartPointFormat);
    }

    /**
     * Creates a WorkbookChartPointFormat with a new object
     *
     * @param newWorkbookChartPointFormat the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookChartPointFormat> postAsync(@Nonnull final WorkbookChartPointFormat newWorkbookChartPointFormat) {
        return sendAsync(HttpMethod.POST, newWorkbookChartPointFormat);
    }

    /**
     * Creates a WorkbookChartPointFormat with a new object
     *
     * @param newWorkbookChartPointFormat the new object to create
     * @return the created WorkbookChartPointFormat
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookChartPointFormat post(@Nonnull final WorkbookChartPointFormat newWorkbookChartPointFormat) throws ClientException {
        return send(HttpMethod.POST, newWorkbookChartPointFormat);
    }

    /**
     * Creates a WorkbookChartPointFormat with a new object
     *
     * @param newWorkbookChartPointFormat the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookChartPointFormat> putAsync(@Nonnull final WorkbookChartPointFormat newWorkbookChartPointFormat) {
        return sendAsync(HttpMethod.PUT, newWorkbookChartPointFormat);
    }

    /**
     * Creates a WorkbookChartPointFormat with a new object
     *
     * @param newWorkbookChartPointFormat the object to create/update
     * @return the created WorkbookChartPointFormat
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookChartPointFormat put(@Nonnull final WorkbookChartPointFormat newWorkbookChartPointFormat) throws ClientException {
        return send(HttpMethod.PUT, newWorkbookChartPointFormat);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public WorkbookChartPointFormatRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public WorkbookChartPointFormatRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

