// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;


import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Application Remove Key Parameter Set.
 */
public class ApplicationRemoveKeyParameterSet {
    /**
     * The key Id.
     * 
     */
    @SerializedName(value = "keyId", alternate = {"KeyId"})
    @Expose
	@Nullable
    public java.util.UUID keyId;

    /**
     * The proof.
     * 
     */
    @SerializedName(value = "proof", alternate = {"Proof"})
    @Expose
	@Nullable
    public String proof;


    /**
     * Instiaciates a new ApplicationRemoveKeyParameterSet
     */
    public ApplicationRemoveKeyParameterSet() {}
    /**
     * Instiaciates a new ApplicationRemoveKeyParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected ApplicationRemoveKeyParameterSet(@Nonnull final ApplicationRemoveKeyParameterSetBuilder builder) {
        this.keyId = builder.keyId;
        this.proof = builder.proof;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static ApplicationRemoveKeyParameterSetBuilder newBuilder() {
        return new ApplicationRemoveKeyParameterSetBuilder();
    }
    /**
     * Fluent builder for the ApplicationRemoveKeyParameterSet
     */
    public static final class ApplicationRemoveKeyParameterSetBuilder {
        /**
         * The keyId parameter value
         */
        @Nullable
        protected java.util.UUID keyId;
        /**
         * Sets the KeyId
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public ApplicationRemoveKeyParameterSetBuilder withKeyId(@Nullable final java.util.UUID val) {
            this.keyId = val;
            return this;
        }
        /**
         * The proof parameter value
         */
        @Nullable
        protected String proof;
        /**
         * Sets the Proof
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public ApplicationRemoveKeyParameterSetBuilder withProof(@Nullable final String val) {
            this.proof = val;
            return this;
        }
        /**
         * Instanciates a new ApplicationRemoveKeyParameterSetBuilder
         */
        @Nullable
        protected ApplicationRemoveKeyParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public ApplicationRemoveKeyParameterSet build() {
            return new ApplicationRemoveKeyParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.keyId != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("keyId", keyId));
        }
        if(this.proof != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("proof", proof));
        }
        return result;
    }
}
