// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.AssignedLicense;
import com.microsoft.graph.models.Group;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Group Assign License Parameter Set.
 */
public class GroupAssignLicenseParameterSet {
    /**
     * The add Licenses.
     * 
     */
    @SerializedName(value = "addLicenses", alternate = {"AddLicenses"})
    @Expose
	@Nullable
    public java.util.List<AssignedLicense> addLicenses;

    /**
     * The remove Licenses.
     * 
     */
    @SerializedName(value = "removeLicenses", alternate = {"RemoveLicenses"})
    @Expose
	@Nullable
    public java.util.List<java.util.UUID> removeLicenses;


    /**
     * Instiaciates a new GroupAssignLicenseParameterSet
     */
    public GroupAssignLicenseParameterSet() {}
    /**
     * Instiaciates a new GroupAssignLicenseParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected GroupAssignLicenseParameterSet(@Nonnull final GroupAssignLicenseParameterSetBuilder builder) {
        this.addLicenses = builder.addLicenses;
        this.removeLicenses = builder.removeLicenses;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static GroupAssignLicenseParameterSetBuilder newBuilder() {
        return new GroupAssignLicenseParameterSetBuilder();
    }
    /**
     * Fluent builder for the GroupAssignLicenseParameterSet
     */
    public static final class GroupAssignLicenseParameterSetBuilder {
        /**
         * The addLicenses parameter value
         */
        @Nullable
        protected java.util.List<AssignedLicense> addLicenses;
        /**
         * Sets the AddLicenses
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public GroupAssignLicenseParameterSetBuilder withAddLicenses(@Nullable final java.util.List<AssignedLicense> val) {
            this.addLicenses = val;
            return this;
        }
        /**
         * The removeLicenses parameter value
         */
        @Nullable
        protected java.util.List<java.util.UUID> removeLicenses;
        /**
         * Sets the RemoveLicenses
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public GroupAssignLicenseParameterSetBuilder withRemoveLicenses(@Nullable final java.util.List<java.util.UUID> val) {
            this.removeLicenses = val;
            return this;
        }
        /**
         * Instanciates a new GroupAssignLicenseParameterSetBuilder
         */
        @Nullable
        protected GroupAssignLicenseParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public GroupAssignLicenseParameterSet build() {
            return new GroupAssignLicenseParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.addLicenses != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("addLicenses", addLicenses));
        }
        if(this.removeLicenses != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("removeLicenses", removeLicenses));
        }
        return result;
    }
}
