// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.ScheduleChangeRequest;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Offer Shift Request.
 */
public class OfferShiftRequest extends ScheduleChangeRequest implements IJsonBackedObject {


    /**
     * The Recipient Action Date Time.
     * The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z
     */
    @SerializedName(value = "recipientActionDateTime", alternate = {"RecipientActionDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime recipientActionDateTime;

    /**
     * The Recipient Action Message.
     * Custom message sent by recipient of the offer shift request.
     */
    @SerializedName(value = "recipientActionMessage", alternate = {"RecipientActionMessage"})
    @Expose
	@Nullable
    public String recipientActionMessage;

    /**
     * The Recipient User Id.
     * User ID of the recipient of the offer shift request.
     */
    @SerializedName(value = "recipientUserId", alternate = {"RecipientUserId"})
    @Expose
	@Nullable
    public String recipientUserId;

    /**
     * The Sender Shift Id.
     * User ID of the sender of the offer shift request.
     */
    @SerializedName(value = "senderShiftId", alternate = {"SenderShiftId"})
    @Expose
	@Nullable
    public String senderShiftId;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
