// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Teams Tab Configuration.
 */
public class TeamsTabConfiguration implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Content Url.
     * Url used for rendering tab contents in Teams. Required.
     */
    @SerializedName(value = "contentUrl", alternate = {"ContentUrl"})
    @Expose
	@Nullable
    public String contentUrl;

    /**
     * The Entity Id.
     * Identifier for the entity hosted by the tab provider.
     */
    @SerializedName(value = "entityId", alternate = {"EntityId"})
    @Expose
	@Nullable
    public String entityId;

    /**
     * The Remove Url.
     * Url called by Teams client when a Tab is removed using the Teams Client.
     */
    @SerializedName(value = "removeUrl", alternate = {"RemoveUrl"})
    @Expose
	@Nullable
    public String removeUrl;

    /**
     * The Website Url.
     * Url for showing tab contents outside of Teams.
     */
    @SerializedName(value = "websiteUrl", alternate = {"WebsiteUrl"})
    @Expose
	@Nullable
    public String websiteUrl;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
