// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.AppScope;
import com.microsoft.graph.models.DirectoryObject;
import com.microsoft.graph.models.UnifiedRoleDefinition;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Unified Role Assignment.
 */
public class UnifiedRoleAssignment extends Entity implements IJsonBackedObject {


    /**
     * The App Scope Id.
     * Identifier of the app-specific scope when the assignment scope is app-specific.  Either this property or directoryScopeId is required. App scopes are scopes that are defined and understood by this application only. Use / for tenant-wide app scopes. Use directoryScopeId to limit the scope to particular directory objects, for example, administrative units. Supports $filter (eq, in).
     */
    @SerializedName(value = "appScopeId", alternate = {"AppScopeId"})
    @Expose
	@Nullable
    public String appScopeId;

    /**
     * The Condition.
     * 
     */
    @SerializedName(value = "condition", alternate = {"Condition"})
    @Expose
	@Nullable
    public String condition;

    /**
     * The Directory Scope Id.
     * Identifier of the directory object representing the scope of the assignment.  Either this property or appScopeId is required. The scope of an assignment determines the set of resources for which the principal has been granted access. Directory scopes are shared scopes stored in the directory that are understood by multiple applications. Use / for tenant-wide scope. Use appScopeId to limit the scope to an application only. Supports $filter (eq, in).
     */
    @SerializedName(value = "directoryScopeId", alternate = {"DirectoryScopeId"})
    @Expose
	@Nullable
    public String directoryScopeId;

    /**
     * The Principal Id.
     * Identifier of the principal to which the assignment is granted. Supports $filter (eq, in).
     */
    @SerializedName(value = "principalId", alternate = {"PrincipalId"})
    @Expose
	@Nullable
    public String principalId;

    /**
     * The Role Definition Id.
     * Identifier of the role definition the assignment is for. Read only. Supports $filter (eq, in).
     */
    @SerializedName(value = "roleDefinitionId", alternate = {"RoleDefinitionId"})
    @Expose
	@Nullable
    public String roleDefinitionId;

    /**
     * The App Scope.
     * Read-only property with details of the app specific scope when the assignment scope is app specific. Containment entity. Supports $expand.
     */
    @SerializedName(value = "appScope", alternate = {"AppScope"})
    @Expose
	@Nullable
    public AppScope appScope;

    /**
     * The Directory Scope.
     * The directory object that is the scope of the assignment. Read-only. Supports $expand.
     */
    @SerializedName(value = "directoryScope", alternate = {"DirectoryScope"})
    @Expose
	@Nullable
    public DirectoryObject directoryScope;

    /**
     * The Principal.
     * Referencing the assigned principal. Read-only. Supports $expand.
     */
    @SerializedName(value = "principal", alternate = {"Principal"})
    @Expose
	@Nullable
    public DirectoryObject principal;

    /**
     * The Role Definition.
     * The roleDefinition the assignment is for.  Supports $expand. roleDefinition.Id will be auto expanded.
     */
    @SerializedName(value = "roleDefinition", alternate = {"RoleDefinition"})
    @Expose
	@Nullable
    public UnifiedRoleDefinition roleDefinition;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
