// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.WorkbookFunctionResult;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Functions Binom_Dist_Range Parameter Set.
 */
public class WorkbookFunctionsBinom_Dist_RangeParameterSet {
    /**
     * The trials.
     * 
     */
    @SerializedName(value = "trials", alternate = {"Trials"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement trials;

    /**
     * The probability S.
     * 
     */
    @SerializedName(value = "probabilityS", alternate = {"ProbabilityS"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement probabilityS;

    /**
     * The number S.
     * 
     */
    @SerializedName(value = "numberS", alternate = {"NumberS"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement numberS;

    /**
     * The number S2.
     * 
     */
    @SerializedName(value = "numberS2", alternate = {"NumberS2"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement numberS2;


    /**
     * Instiaciates a new WorkbookFunctionsBinom_Dist_RangeParameterSet
     */
    public WorkbookFunctionsBinom_Dist_RangeParameterSet() {}
    /**
     * Instiaciates a new WorkbookFunctionsBinom_Dist_RangeParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookFunctionsBinom_Dist_RangeParameterSet(@Nonnull final WorkbookFunctionsBinom_Dist_RangeParameterSetBuilder builder) {
        this.trials = builder.trials;
        this.probabilityS = builder.probabilityS;
        this.numberS = builder.numberS;
        this.numberS2 = builder.numberS2;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookFunctionsBinom_Dist_RangeParameterSetBuilder newBuilder() {
        return new WorkbookFunctionsBinom_Dist_RangeParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookFunctionsBinom_Dist_RangeParameterSet
     */
    public static final class WorkbookFunctionsBinom_Dist_RangeParameterSetBuilder {
        /**
         * The trials parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement trials;
        /**
         * Sets the Trials
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsBinom_Dist_RangeParameterSetBuilder withTrials(@Nullable final com.google.gson.JsonElement val) {
            this.trials = val;
            return this;
        }
        /**
         * The probabilityS parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement probabilityS;
        /**
         * Sets the ProbabilityS
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsBinom_Dist_RangeParameterSetBuilder withProbabilityS(@Nullable final com.google.gson.JsonElement val) {
            this.probabilityS = val;
            return this;
        }
        /**
         * The numberS parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement numberS;
        /**
         * Sets the NumberS
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsBinom_Dist_RangeParameterSetBuilder withNumberS(@Nullable final com.google.gson.JsonElement val) {
            this.numberS = val;
            return this;
        }
        /**
         * The numberS2 parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement numberS2;
        /**
         * Sets the NumberS2
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsBinom_Dist_RangeParameterSetBuilder withNumberS2(@Nullable final com.google.gson.JsonElement val) {
            this.numberS2 = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookFunctionsBinom_Dist_RangeParameterSetBuilder
         */
        @Nullable
        protected WorkbookFunctionsBinom_Dist_RangeParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookFunctionsBinom_Dist_RangeParameterSet build() {
            return new WorkbookFunctionsBinom_Dist_RangeParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.trials != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("trials", trials));
        }
        if(this.probabilityS != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("probabilityS", probabilityS));
        }
        if(this.numberS != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("numberS", numberS));
        }
        if(this.numberS2 != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("numberS2", numberS2));
        }
        return result;
    }
}
