// Template Source: BaseEntityCollectionReferenceRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.User;
import com.microsoft.graph.models.AgreementAcceptance;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.AgreementAcceptanceWithReferenceRequest;
import com.microsoft.graph.requests.AgreementAcceptanceReferenceRequestBuilder;
import com.microsoft.graph.requests.AgreementAcceptanceWithReferenceRequestBuilder;
import com.microsoft.graph.requests.AgreementAcceptanceCollectionWithReferencesRequest;
import com.microsoft.graph.requests.AgreementAcceptanceCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.models.AgreementAcceptance;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionWithReferencesRequest;
import com.microsoft.graph.http.BaseCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.http.ReferenceRequestBody;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Agreement Acceptance Collection Reference Request.
 */
public class AgreementAcceptanceCollectionReferenceRequest extends BaseCollectionWithReferencesRequest<AgreementAcceptance, AgreementAcceptanceWithReferenceRequest, AgreementAcceptanceReferenceRequestBuilder, AgreementAcceptanceWithReferenceRequestBuilder, AgreementAcceptanceCollectionResponse, AgreementAcceptanceCollectionWithReferencesPage, AgreementAcceptanceCollectionWithReferencesRequest> {

    /**
     * The request builder for this collection of AgreementAcceptance
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AgreementAcceptanceCollectionReferenceRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AgreementAcceptanceCollectionResponse.class, AgreementAcceptanceCollectionWithReferencesPage.class, AgreementAcceptanceCollectionWithReferencesRequestBuilder.class);
    }

    /**
     * Creates a new AgreementAcceptance
     * @param newAgreementAcceptance the AgreementAcceptance to create
     * @return a future with the created object
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AgreementAcceptance> postAsync(@Nonnull final AgreementAcceptance newAgreementAcceptance) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        final ReferenceRequestBody body = new ReferenceRequestBody(getBaseRequest().getClient().getServiceRoot() + "/agreementAcceptances/" + newAgreementAcceptance.id);
        return new AgreementAcceptanceWithReferenceRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getHeaders())
            .postAsync(newAgreementAcceptance, body);
    }

    /**
     * Creates a new AgreementAcceptance
     * @param newAgreementAcceptance the AgreementAcceptance to create
     * @return the newly created object
     */
    @Nonnull
    public AgreementAcceptance post(@Nonnull final AgreementAcceptance newAgreementAcceptance) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        final ReferenceRequestBody body = new ReferenceRequestBody(getBaseRequest().getClient().getServiceRoot() + "/agreementAcceptances/" + newAgreementAcceptance.id);
        return new AgreementAcceptanceWithReferenceRequestBuilder(requestUrl,getBaseRequest().getClient(), /* Options */ null)
                .buildRequest(getBaseRequest().getHeaders())
                .post(newAgreementAcceptance, body);
    }
    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    @Nonnull
    public AgreementAcceptanceCollectionReferenceRequest expand(@Nonnull final String value) {
        addExpandOption(value);
        return this;
    }

    /**
     * Sets the filter clause for the request
     *
     * @param value the filter clause
     * @return the updated request
     */
    @Nonnull
    public AgreementAcceptanceCollectionReferenceRequest filter(@Nonnull final String value) {
        addFilterOption(value);
        return this;
    }

    /**
     * Sets the order by clause for the request
     *
     * @param value the sort clause
     * @return the updated request
     */
    @Nonnull
    public AgreementAcceptanceCollectionReferenceRequest orderBy(@Nonnull final String value) {
        addOrderByOption(value);
        return this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    @Nonnull
    public AgreementAcceptanceCollectionReferenceRequest select(@Nonnull final String value) {
        addSelectOption(value);
        return this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value the max number of items to return
     * @return the updated request
     */
    @Nonnull
    public AgreementAcceptanceCollectionReferenceRequest top(final int value) {
        addTopOption(value);
        return this;
    }
    /**
     * Sets the count value for the request
     *
     * @param value whether or not to return the count of objects with the request
     * @return the updated request
     */
    @Nonnull
    public AgreementAcceptanceCollectionReferenceRequest count(final boolean value) {
        addCountOption(value);
        return this;
    }
    /**
     * Sets the count value to true for the request
     *
     * @return the updated request
     */
    @Nonnull
    public AgreementAcceptanceCollectionReferenceRequest count() {
        addCountOption(true);
        return this;
    }
}
