// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.WorkbookChartSeries;
import com.microsoft.graph.requests.WorkbookChartSeriesFormatRequestBuilder;
import com.microsoft.graph.requests.WorkbookChartPointCollectionRequestBuilder;
import com.microsoft.graph.requests.WorkbookChartPointRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Chart Series Request Builder.
 */
public class WorkbookChartSeriesRequestBuilder extends BaseRequestBuilder<WorkbookChartSeries> {

    /**
     * The request builder for the WorkbookChartSeries
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WorkbookChartSeriesRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the WorkbookChartSeriesRequest instance
     */
    @Nonnull
    public WorkbookChartSeriesRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the WorkbookChartSeriesRequest instance
     */
    @Nonnull
    public WorkbookChartSeriesRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.WorkbookChartSeriesRequest(getRequestUrl(), getClient(), requestOptions);
    }



    /**
     * Gets the request builder for WorkbookChartSeriesFormat
     *
     * @return the WorkbookChartSeriesFormatRequestBuilder instance
     */
    @Nonnull
    public WorkbookChartSeriesFormatRequestBuilder format() {
        return new WorkbookChartSeriesFormatRequestBuilder(getRequestUrlWithAdditionalSegment("format"), getClient(), null);
    }
    /**
     *  Gets a request builder for the WorkbookChartPoint collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public WorkbookChartPointCollectionRequestBuilder points() {
        return new WorkbookChartPointCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("points"), getClient(), null);
    }

    /**
     * Gets a request builder for the WorkbookChartPoint item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public WorkbookChartPointRequestBuilder points(@Nonnull final String id) {
        return new WorkbookChartPointRequestBuilder(getRequestUrlWithAdditionalSegment("points") + "/" + id, getClient(), null);
    }
}
