/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.framework.decorator;

import com.nepxion.discovery.plugin.framework.context.PluginContextAware;
import com.nepxion.discovery.plugin.framework.listener.discovery.DiscoveryListenerExecutor;
import java.util.List;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

public class DiscoveryClientDecorator
implements DiscoveryClient {
    private DiscoveryClient discoveryClient;
    private ConfigurableApplicationContext applicationContext;
    private ConfigurableEnvironment environment;

    public DiscoveryClientDecorator(DiscoveryClient discoveryClient, ConfigurableApplicationContext applicationContext) {
        this.discoveryClient = discoveryClient;
        this.applicationContext = applicationContext;
        this.environment = applicationContext.getEnvironment();
    }

    public List<ServiceInstance> getInstances(String serviceId) {
        List<ServiceInstance> instances = this.getRealInstances(serviceId);
        Boolean discoveryControlEnabled = PluginContextAware.isDiscoveryControlEnabled((Environment)this.environment);
        if (discoveryControlEnabled.booleanValue()) {
            DiscoveryListenerExecutor discoveryListenerExecutor = (DiscoveryListenerExecutor)this.applicationContext.getBean(DiscoveryListenerExecutor.class);
            discoveryListenerExecutor.onGetInstances(serviceId, instances);
        }
        return instances;
    }

    public List<ServiceInstance> getRealInstances(String serviceId) {
        return this.discoveryClient.getInstances(serviceId);
    }

    public List<String> getServices() {
        List<String> services = this.getRealServices();
        Boolean discoveryControlEnabled = PluginContextAware.isDiscoveryControlEnabled((Environment)this.environment);
        if (discoveryControlEnabled.booleanValue()) {
            DiscoveryListenerExecutor discoveryListenerExecutor = (DiscoveryListenerExecutor)this.applicationContext.getBean(DiscoveryListenerExecutor.class);
            discoveryListenerExecutor.onGetServices(services);
        }
        return services;
    }

    public List<String> getRealServices() {
        return this.discoveryClient.getServices();
    }

    public String description() {
        return this.discoveryClient.description();
    }

    public ConfigurableEnvironment getEnvironment() {
        return this.environment;
    }
}

