/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.framework.listener.discovery;

import com.nepxion.discovery.plugin.framework.listener.discovery.DiscoveryListener;
import com.nepxion.discovery.plugin.framework.listener.discovery.HostFilterDiscoveryListener;
import com.nepxion.discovery.plugin.framework.listener.discovery.VersionFilterDiscoveryListener;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ServiceInstance;

public class DiscoveryListenerExecutor {
    @Autowired
    private HostFilterDiscoveryListener hostFilterDiscoveryListener;
    @Autowired
    private VersionFilterDiscoveryListener versionFilterDiscoveryListener;
    @Autowired
    private List<DiscoveryListener> discoveryListenerList;

    public void onGetInstances(String serviceId, List<ServiceInstance> instances) {
        this.hostFilterDiscoveryListener.onGetInstances(serviceId, instances);
        this.versionFilterDiscoveryListener.onGetInstances(serviceId, instances);
        for (DiscoveryListener discoveryListener : this.discoveryListenerList) {
            if (discoveryListener == this.hostFilterDiscoveryListener || discoveryListener == this.versionFilterDiscoveryListener) continue;
            discoveryListener.onGetInstances(serviceId, instances);
        }
    }

    public void onGetServices(List<String> services) {
        this.hostFilterDiscoveryListener.onGetServices(services);
        this.versionFilterDiscoveryListener.onGetServices(services);
        for (DiscoveryListener discoveryListener : this.discoveryListenerList) {
            if (discoveryListener == this.hostFilterDiscoveryListener || discoveryListener == this.versionFilterDiscoveryListener) continue;
            discoveryListener.onGetServices(services);
        }
    }
}

